<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Actividades_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function get_actividades($filters = [], $limit = 10, $offset = 0) {
        if (!empty($filters)) {
            if (!empty($filters['descripcion'])) {
                $this->db->like('descripcion', $this->db->escape_str($filters['descripcion']));
            }
        }

        $this->db->limit($limit, $offset);
        return $this->db->get('ema.actividades')->result();
    }

    public function count_actividades($filters = []) {
        if (!empty($filters['descripcion'])) {
            $this->db->like('descripcion', $filters['descripcion']);
        }
        return $this->db->count_all_results('ema.actividades');
    }

    public function get_actividad_by_id($id) {
        return $this->db->where('id', $id)->get('ema.actividades')->row_array();
    }

    public function create_actividad($data) {
        return $this->db->insert('ema.actividades', $data);
    }

    public function update_actividad($id, $data) {
        return $this->db->where('id', $id)->update('ema.actividades', $data);
    }

    public function delete_actividad($id) {
        return $this->db->where('id', $id)->delete('ema.actividades');
    }
}
