<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class proyectos extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();  

		$this->load->model('man_espacial/proyectos/Proyectos_model');
		$this->load->model('Tumba_model');
		$this->load->model('Dpto_model');
        $this->load->model('Distritos_model');
        $this->load->model('Barloc_model');
		$this->load->model('Proyectos_evaluaciones_model');
		$this->load->library('ion_auth');
		$this->lang->load('proyectos/proyectos');
		// inicializamos la librería
        $this->load->library('Classes/PHPExcel.php');
        $this->load->library('pagination');

		/* Titulo de la pagina :: Common */ 
		$this->page_title->push(lang('menu_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();

		if ($_SESSION['id_modulo'] != 'proyectos') {
			$_SESSION['arraywhere_proyectos'] 			= NULL;
			$_SESSION['arraywhere_proyectos_busq'] 		= NULL;
			$_SESSION['id_modulo'] = 'proyectos';
		}
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'admin/proyectos');
	}
	
	public function get_distritos()
	{
		$dpto = $this->input->post('dpto');
		$dpto = str_pad((string) $dpto, 2, '0', STR_PAD_LEFT);
		$distritos = $this->Proyectos_model->get_distritos_by_dpto($dpto);
		echo json_encode($distritos);
	}

	public function get_barloc()
	{
		$dpto = $this->input->post('dpto');
		$distrito = $this->input->post('distrito');

		// Convertir a cadena y agregar cero si es del 1 al 9
		$dpto = str_pad((string) $dpto, 2, '0', STR_PAD_LEFT);

		$barlocs = $this->Proyectos_model->get_barloc_by_distrito($dpto, $distrito);
		
		echo json_encode($barlocs);
	}
	
	public function index($id_proyecto = NULL)
	{
		$id_cliente = $this->Proyectos_model->get_cliente_id_usuario_actual();
		// Obtener los filtros desde el formulario
		$filters = [
			'gid' => $this->input->get('gid'),
			'codigo' => $this->input->get('codigo'),
			'nombre' => $this->input->get('nombre'),
			'estado' => $this->input->get('estado'),
			'des_estado' => $this->input->get('des_estado'),
			'consultor' => $this->input->get('consultor'),
			'proponente' => $this->input->get('proponente'),
			'fecha_inicio' => $this->input->get('fecha_inicio'),
			'fecha_inicio2' => $this->input->get('fecha_inicio2')
		];

		if ($id_cliente !== NULL) {
			$filters['id_cliente'] = $id_cliente;
		}

		// Filtra valores vacíos para evitar agregar parámetros innecesarios a la URL
		$filters = array_filter($filters, function ($value) {
			return $value !== null && $value !== '';
		});

		$user_id = $this->session->userdata('user_id');
		$tipo_usuario = $_SESSION['tipo_usuario'][0];
		$id_cliente = $_SESSION['id_cliente'][0];

		if ($tipo_usuario == 'C') {
			$filters['id_cliente'] = $id_cliente;
		}
		
		// Configurar idioma, charset y otras variables
		$this->data['lang'] = $this->lang->load('proyectos/proyectos_lang', 'spanish');
		$this->data['charset'] = 'UTF-8';
		$this->data['mobile'] = FALSE;

		// Construir la query string con los filtros actuales
		$query_string = http_build_query($filters);

		// Configuración de la paginación
		$config['base_url'] = site_url('man_espacial/proyectos/proyectos/index') . '?' . $query_string;
		$config['total_rows'] = $this->Proyectos_model->count_proyectos($filters);
		$config['per_page'] = 10;
		$config['page_query_string'] = TRUE; // Habilita la paginación con query string

		// Inicializar paginación
		$this->pagination->initialize($config);

		// Obtener el offset de la URL (si no está presente, asignar 0)
		$offset = $this->input->get('per_page', TRUE) ?: 0;

		// Obtener proyectos paginados
		$data['proyectos'] = $this->Proyectos_model->get_proyectos($filters, $config['per_page'], $offset);
		$data['pagination'] = $this->pagination->create_links();
		$data['filters'] = $filters;

		// Obtener lista de estados desde el modelo
		$estados = $this->Proyectos_model->concepto2('PROYECTO_ESTADO', false, 'CONCEPTO');
		$dropdown_estados = ['' => 'Seleccione un Estado'];
		foreach ($estados as $estado) {
			$dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
		}
		
		$data['dropdown_estados'] = $dropdown_estados;
		
		// Renderizar vista
		$this->template->admin_render('man_espacial/proyectos/index2', array_merge($data, $this->data));
	}
	



	public function index2()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

			/*
			echo '<pre>';
			echo 'user_id: ';
			print_r($user_id);

			echo 'tipo_usuario: ';
			print_r($tipo_usuario);

			echo 'Contenido de $_SESSION: ';
			print_r($_SESSION);
			echo '</pre>';
            */
			
			//show();

		$user_id= $this->session->userdata('user_id');
		$tipo_usuario = $_SESSION['tipo_usuario'][0];
		$id_cliente = $_SESSION['id_cliente'][0];
	
		if ($tipo_usuario == 'C' && !$_POST) {
			$arraywhere = $_SESSION['arraywhere_proyectos'];
			$arraywherebusq = $_SESSION['arraywhere_proyectos_busq'];					

			if (isset($id_cliente) && !empty($id_cliente)) {
				$arraywhere['id_cliente'] = $id_cliente;
				$arraywherebusq['id_cliente'] = $id_cliente;
			} else {
				echo 'Error: id_cliente no está configurado en la sesión.';
				exit();
			}
			$_SESSION['arraywhere_proyectos'] = $arraywhere;
			$_SESSION['arraywhere_proyectos_busq'] = $arraywherebusq;					
		}
	 

            if ($_POST) {
            	
				if ($_POST['gid']) 
				{
					if (is_numeric($_POST['gid'])) {
						$arraywhere['gid'] 					= $_POST['gid'];
						$arraywherebusq['gid'] 				= $_POST['gid'];
					}
				}
				if ($_POST['col_cod']) 	
				{   if (is_numeric($_POST['col_cod'])) {
						$arraywhere['col_cod'] 					= $_POST['col_cod'];
						$arraywherebusq['col_cod'] 				= $_POST['col_cod'];
					}
				}
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 						= $_POST['nombre'];
					$arraywherebusq['lower(nombre) like '] 		= '%'.strtolower($_POST['nombre']).'%';
				}
				if ($_POST['codigo']) 
				{
					$arraywhere['codigo'] 						= $_POST['codigo'];
					$arraywherebusq['lower(codigo) like '] 			= '%'.strtolower($_POST['codigo']).'%';
				}
				if ($_POST['proponente']) 
				{
					$arraywhere['proponente'] 					= $_POST['proponente'];
					$arraywherebusq['proponente like '] 		= '%'.$_POST['proponente'].'%';
				}
				if ($_POST['consultor']) 
				{
					$arraywhere['consultor'] 					= $_POST['consultor'];
					$arraywherebusq['consultor like '] 			= '%'.$_POST['consultor'].'%';
				}				
				if ($_POST['fecha_registro']) 
				{
					$arraywhere['fecha_registro'] 				= $_POST['fecha_registro'];
					$arraywherebusq['fecha_registro like '] 	= '%'.$_POST['fecha_registro'].'%';
				}
				if ($_POST['descripcion']) 
				{
					$arraywhere['descripcion'] 					= $_POST['descripcion'];
					$arraywherebusq['descripcion like '] 		= '%'.$_POST['descripcion'].'%';
				}												

				$_SESSION['arraywhere_proyectos'] = $arraywhere;
				$_SESSION['arraywhere_proyectos_busq'] = $arraywherebusq;			

				redirect('man_espacial/proyectos/proyectos/index');			

			}
			
				$user_id= $this->session->userdata('user_id');
				$tipo_usuario = $_SESSION['tipo_usuario'][0];
				$id_cliente = $_SESSION['id_cliente'][0];

				if ($tipo_usuario == 'C') {
					$arraywhere = $_SESSION['arraywhere_proyectos'];
					$arraywherebusq = $_SESSION['arraywhere_proyectos_busq'];					
					if (isset($id_cliente) && !empty($id_cliente)) {
						$arraywhere['id_cliente'] = $id_cliente;
						$arraywherebusq['id_cliente'] = $id_cliente;
					} else {
						echo 'Error: id_cliente no está configurado en la sesión.';
						exit();
					}
					$_SESSION['arraywhere_proyectos'] = $arraywhere;
					$_SESSION['arraywhere_proyectos_busq'] = $arraywherebusq;					
				}  
				

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				8, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/proyectos/proyectos/index/',  // url completa de la pagina paginada
				'v_proyectos_index',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_proyectos_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['proyectos']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'v_proyectos_index',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_proyectos_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/proyectos/index', $this->data);
		}
	}




	public function create()
	{
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin()) {
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proyectos'), 'proyectos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		// Reglas de validación
		$this->form_validation->set_rules('nombre', 'lang:proyectos_nombre', 'required|max_length[100]');
		$this->form_validation->set_rules('fecha_inicio', 'Fecha Inicio', 'trim');
		$this->form_validation->set_rules('fecha_final', 'Fecha Final', 'trim');
		$this->form_validation->set_rules('fecha_registro', 'Fecha Registro', 'trim');
		$this->form_validation->set_rules(
			'codigo',
			lang('proyectos_codigo'),
			'required|max_length[10]|regex_match[/^([A-Z]{1,3}[0-9]{1,7})?$/]',
			array(
				'regex_match' => 'El campo {field} debe comenzar con letras mayúsculas y contener hasta 3 dígitos, seguido de hasta 7 números.'
			)
		);

		$this->form_validation->set_rules('actividad', 'Actividad', 'max_length[200]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} no debe superar los 200 caracteres.')
		);

		$this->form_validation->set_rules('id_grupoproyecto', 'Grupo Proyecto', 'max_length[1]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} solo puede contener 1 caracter.')
		);

		$this->form_validation->set_rules('coor_x', 'Coordenada X', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('coor_y', 'Coordenada Y', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('col_cod', 'Código de Colonia', 'integer', 
			array('required' => 'El campo {field} es obligatorio.', 'integer' => 'El campo {field} debe ser un número entero.')
		);

		$this->form_validation->set_rules('exp_gestion', 'Expediente de Gestión', 'numeric|exact_length[4]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'exact_length' => 'El campo {field} debe tener exactamente 4 dígitos.')
		);

		$this->form_validation->set_rules('exp_numero', 'Número de Expediente', 'numeric|max_length[7]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'max_length' => 'El campo {field} no debe superar los 7 dígitos.')
		);
		$this->form_validation->set_rules('tipo_estudio', 'Tipo de Estudio', 'max_length[100]');
		$this->form_validation->set_rules('tipo_proyecto', 'Tipo de Proyecto', 'max_length[100]');
		$this->form_validation->set_rules('dpto', 'Departamento', 'max_length[100]');
		$this->form_validation->set_rules('distrito', 'Distrito', 'max_length[100]');
		$this->form_validation->set_rules('localidad', 'Localidad', 'max_length[100]');
		$this->form_validation->set_rules('barrio', 'Barrio', 'max_length[100]');
		$this->form_validation->set_rules('sector_proyecto', 'Sector Proyecto', 'max_length[100]');
		$this->form_validation->set_rules('id_consultor', 'Consultor', 
		array('required' => 'El campo {field} es obligatorio.'));

		/* $this->form_validation->set_rules('nombre', lang('proyectos_nombre'), 'required');
		$this->form_validation->set_rules('fecha_registro', 'Date');
		$this->form_validation->set_rules(
			'codigo',
			lang('proyectos_codigo'),
			'required|max_length[10]|regex_match[/^([A-Z]{1,3}[0-9]{1,7})?$/]',
			array(
				'regex_match' => 'El campo {field} debe comenzar con letras mayúsculas y contener hasta 3 dígitos, seguido de hasta 7 números.'
			)
		); */
		/* $this->form_validation->set_rules('tipo_proyecto', 'Tipo de Proyecto', 'required|max_length[5]'); */
		/* $this->form_validation->set_rules('dpto', 'Departamento', 'required|max_length[2]');
		$this->form_validation->set_rules('distrito', 'Distrito', 'required|max_length[2]');
		$this->form_validation->set_rules('barloc', 'Localidad', 'required|max_length[20]');
		$this->form_validation->set_rules('actividad', 'Actividad', 'required|max_length[200]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} no debe superar los 200 caracteres.')
		);

		$this->form_validation->set_rules('id_grupoproyecto', 'Grupo Proyecto', 'max_length[1]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} solo puede contener 1 caracter.')
		);

		$this->form_validation->set_rules('coor_x', 'Coordenada X', 'greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('coor_y', 'Coordenada Y', 'greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		
		$this->form_validation->set_rules('tipo_estudio', 'Tipo de Estudio', 'max_length[100]');
		$this->form_validation->set_rules('tipo_proyecto', 'Tipo de Proyecto', 'max_length[100]');
		$this->form_validation->set_rules('dpto', 'Departamento', 'max_length[100]');
		$this->form_validation->set_rules('distrito', 'Distrito', 'max_length[100]');
		$this->form_validation->set_rules('localidad', 'Localidad', 'max_length[100]');
		$this->form_validation->set_rules('barrio', 'Barrio', 'max_length[100]');
		$this->form_validation->set_rules('sector_proyecto', 'Sector Proyecto', 'max_length[100]');
 		*/
		/* $this->form_validation->set_rules('dp_sector', 'Sector del Proyecto', 'max_length[100]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} no debe superar los 100 caracteres.')
		); */
		/* $this->form_validation->set_rules('tipo_estudio', 'Tipo de Estudio', 'required|max_length[60]'); */
		
		

		if ($this->form_validation->run() === TRUE) {
			// Procesar datos del formulario
			$arraycampos = array(
				'expediente' => strtoupper($this->input->post('expediente')),
				'codigo' => strtoupper($this->input->post('codigo')),
				'nombre' => strtoupper($this->input->post('nombre')),
				'id_consultor' => !empty($this->input->post('dp_consultores')) ? $this->input->post('dp_consultores') : NULL,
				'id_proponente' => !empty($this->input->post('dp_proponentes')) ? $this->input->post('dp_proponentes') : NULL,
				'id_cliente' => !empty($this->input->post('dp_clientes')) ? $this->input->post('dp_clientes') : NULL,
				'fecha_inicio' => !empty($this->input->post('fecha_inicio')) ? date('Y-m-d', strtotime(str_replace('/', '-', $this->input->post('fecha_inicio')))) : NULL,
				'fecha_final' => !empty($this->input->post('fecha_final')) ? date('Y-m-d', strtotime(str_replace('/', '-', $this->input->post('fecha_final')))) : NULL,
				'fecha_registro' => !empty($this->input->post('fecha_registro')) ? date('Y-m-d', strtotime(str_replace('/', '-', $this->input->post('fecha_registro')))) : NULL,
				'descripcion' => trim($this->input->post('descripcion')),
				'padron' => strtoupper($this->input->post('padron')),
				'cta_cte' => strtoupper($this->input->post('cta_cte')),
				'estado' => $this->input->post('dp_estado'),
				'expediente_hidrico' => strtoupper($this->input->post('expediente_hidrico')),
				'finca' => strtoupper($this->input->post('finca')),
				'matricula' => strtoupper($this->input->post('matricula')),
				'tipo_estudio' => strtoupper($this->input->post('dp_tipo_estudio_2')),
				'tipo_proyecto' => strtoupper($this->input->post('dp_tipo_proyecto')),
				'dpto' => strtoupper($this->input->post('dpto')),
				'distrito' => strtoupper($this->input->post('distrito')),
				'localidad' => strtoupper($this->input->post('barloc')),
				'barrio' => strtoupper($this->input->post('barloc')),
				'actividad' => strtoupper($this->input->post('dp_actividad')),
				'id_grupoproyecto' => !empty($this->input->post('id_grupoproyecto')) ? $this->input->post('id_grupoproyecto') : NULL,
				'coor_x' => trim($this->input->post('coor_x')) !== '' ? trim($this->input->post('coor_x')) : NULL,
				'coor_y' => trim($this->input->post('coor_y')) !== '' ? trim($this->input->post('coor_y')) : NULL,
				'col_cod' => !empty($this->input->post('col_cod')) ? $this->input->post('col_cod') : NULL,
				'exp_gestion' => !empty($this->input->post('exp_gestion')) ? $this->input->post('exp_gestion') : NULL,
				'exp_numero' => !empty($this->input->post('exp_numero')) ? $this->input->post('exp_numero') : NULL,
				'sector_proyecto' => strtoupper($this->input->post('dp_sector')),
			);
			
			if ($this->Proyectos_model->codigo_existe($arraycampos['codigo'])) {
				$this->session->set_userdata('error', 'El código ya existe. Elige otro.');
				redirect('man_espacial/proyectos/proyectos/create');
			} else {
				$new_colonia_id = $this->Proyectos_model->create_colonia($arraycampos);
				redirect('man_espacial/proyectos/proyectos');
			}

			$new_colonia_id = $this->Proyectos_model->create_colonia($arraycampos);
			
			if ($new_colonia_id) {
				// Subida de documentos si existen archivos seleccionados
				if ($new_colonia_id) {
					// Crear la carpeta con el ID del proyecto
					$folder_path = 'C:/dir_ema/archivos/proyectos/' . $new_colonia_id .'/';
		
					if (!is_dir($folder_path)) {
						mkdir($folder_path, 0777, true);  // Crear la carpeta con permisos
					}
		
					// Subida de documentos si existen archivos seleccionados
					if (!empty($_FILES['documento']['name'][0])) {
						$tipo_documento = '1'; // Aquí defines el tipo de documento (1 para proyectos, 2 para declaraciones, etc.)
						$upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $new_colonia_id, $tipo_documento);
		
						if ($upload_result['status']) {
							$this->session->set_flashdata('message', 'Proyecto y documentos cargados correctamente.');
						} else {
							$this->session->set_flashdata('error', 'Error al cargar documentos: ' . implode(', ', $upload_result['errors']));
						}
					} else {
						$this->session->set_flashdata('message', 'Proyecto creado sin documentos.');
					}
		
					$this->session->set_flashdata('message', $this->ion_auth->messages());
					redirect('man_espacial/proyectos/proyectos');
				}
				
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('man_espacial/proyectos/proyectos');
			}
		} else {
			// Mensajes de error de validación
		$this->data['message'] = validation_errors() ?: ($this->ion_auth->errors() ?: $this->session->flashdata('message'));
		$this->data['departamentos'] = $this->Proyectos_model->get_departamentos();
		// Inicialización de variables para la vista
		$this->data['expediente'] = array(
			'name' => 'expediente',
			'id' => 'expediente',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('expediente', '')
		);

		$this->data['codigo'] = array(
			'name' => 'codigo',
			'id' => 'codigo',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('codigo', '')
		);

		$this->data['nombre'] = array(
			'name' => 'nombre',
			'id' => 'nombre',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('nombre', '')
		);

		$this->data['descripcion'] = array(
			'name' => 'descripcion',
			'id' => 'descripcion',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('descripcion', '')
		);

		$this->data['padron'] = array(
			'name' => 'padron',
			'id' => 'padron',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('padron', '')
		);

		$this->data['cta_cte'] = array(
			'name' => 'cta_cte',
			'id' => 'cta_cte',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('cta_cte', '')
		);

		$this->data['fecha_inicio'] = array(
			'name' => 'fecha_inicio',
			'id' => 'fecha_inicio',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('fecha_inicio', '')
		);

		$this->data['fecha_final'] = array(
			'name' => 'fecha_final',
			'id' => 'fecha_final',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('fecha_final', '')
		);

		$this->data['fecha_registro'] = array( 
			'name'  => 'fecha_registro',
			'id'    => 'fecha_registro',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => set_value('fecha_registro', date('d/m/Y'))
		);		

		$this->data['expediente_hidrico'] = array(
			'name' => 'expediente_hidrico',
			'id' => 'expediente_hidrico',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('expediente_hidrico', '')
		);

		$this->data['finca'] = array(
			'name' => 'finca',
			'id' => 'finca',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('finca', '')
		);

		$this->data['matricula'] = array(
			'name' => 'matricula',
			'id' => 'matricula',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('matricula', '')
		);
		
		$this->data['dpto'] = array(
			'name' => 'dpto',
			'id' => 'dpto',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('dpto', '')
		);
		
		$this->data['distrito'] = array(
			'name' => 'distrito',
			'id' => 'distrito',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('distrito', '')
		);
		
		$this->data['localidad'] = array(
			'name' => 'localidad',
			'id' => 'localidad',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('localidad', '')
		);
		
		$this->data['barrio'] = array(
			'name' => 'barrio',
			'id' => 'barrio',
			'type' => 'text',
			'class' => 'form-control',
			'value' => set_value('barrio', '')
		);
		

		// Dropdowns dinámicos
		$a_consultores[''] = 'Seleccione el Consultor';
		$d_consultores = $this->Proyectos_model->dropdown_data('consultores')->result_array();
		foreach ($d_consultores as $r_consultor) {
			$a_consultores[$r_consultor['id_consultor']] = $r_consultor['id_consultor'] . ' - ' . $r_consultor['nombre'];
		}
		$this->data['consultores'] = $a_consultores;

		$a_proponentes[''] = 'Seleccione el Proponente';
		$d_proponentes = $this->Proyectos_model->dropdown_data('proponentes')->result_array();
		foreach ($d_proponentes as $r_proponente) {
			$a_proponentes[$r_proponente['id_proponente']] = $r_proponente['id_proponente'] . ' - ' . $r_proponente['nombre'];
		}
		$this->data['proponentes'] = $a_proponentes;

		$a_clientes[''] = 'Seleccione el Proponente';
		$d_clientes = $this->Proyectos_model->dropdown_data('cliente')->result_array();

		foreach ($d_clientes as $r_cliente) {
			$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
		}

		$this->data['cliente'] = $a_clientes;

		$a_estado[''] = 'Seleccione Estado';
		$d_estado = $this->Proyectos_model->concepto('PROYECTO_ESTADO', false, 'CONCEPTO')->result_array();
		foreach ($d_estado as $r_estado) {
			$a_estado[$r_estado['concepto']] = $r_estado['concepto'] . ' - ' . $r_estado['nombre'];
		}
		$this->data['estado'] = $a_estado;

		$a_sector[''] = 'Seleccione Sector';

		$d_sector = $this->Proyectos_model->concepto('SECTORE_PROYECTOS', false, 'CONCEPTO')->result_array();
		foreach ($d_sector as $r_sector) {
			$a_sector[$r_sector['concepto']] = $r_sector['concepto'] . ' - ' . $r_sector['nombre'];
		}
		$this->data['sector'] = $a_sector;

		$d_tipo_proyecto = $this->Proyectos_model->concepto('TIPO_PROYECTO', false, 'CONCEPTO')->result_array();
		foreach ($d_tipo_proyecto as $r_tipo_proyecto) {
			$a_tipo_proyecto[$r_tipo_proyecto['concepto']] = $r_tipo_proyecto['concepto'] . ' - ' . $r_tipo_proyecto['nombre'];
		}
		$this->data['tipo_proyecto'] = $a_tipo_proyecto;

		$d_grupo_proyecto = $this->Proyectos_model->concepto('TIPO_ESTUDIO', false, 'CONCEPTO')->result_array();
		foreach ($d_grupo_proyecto as $r_grupo_proyecto) {
			$a_grupo_proyecto[$r_grupo_proyecto['concepto']] = $r_grupo_proyecto['concepto'] . ' - ' . $r_grupo_proyecto['nombre'];
		}
		$this->data['grupo_proyecto'] = $a_grupo_proyecto;

		$d_tipo_estudio_2 = $this->Proyectos_model->concepto('TIPO_ESTUDIO', false, 'CONCEPTO')->result_array();
		foreach ($d_tipo_estudio_2 as $r_tipo_estudio_2) {
			$a_tipo_estudio_2[$r_tipo_estudio_2['concepto']] = $r_tipo_estudio_2['concepto'] . ' - ' . $r_tipo_estudio_2['nombre'];
		}
		$this->data['tipo_estudio_2'] = $a_tipo_estudio_2;
		
		$a_actividades[''] = 'Seleccione la actividad';
		$d_actividades = $this->Proyectos_model->dropdown_data('actividades')->result_array();

		foreach ($d_actividades as $r_actividad) {
			$a_actividades[$r_actividad['id']] = $r_actividad['id'] . ' - ' . $r_actividad['descripcion'];
		}

		$this->data['actividad'] = $a_actividades;

		

			/* Cargar la vista */
			$this->template->admin_render('man_espacial/proyectos/create', $this->data);
		}
	}

    // Función de validación personalizada
    public function valid_date($date) {
        // Validar la fecha en formato dd/mm/yyyy
        $d = DateTime::createFromFormat('d/m/Y', $date);
		/*
	        echo '<pre>';
	        print_r( $d1 );
	        echo '</pre>';
	        show_error(1); 
		*/
        if ($d !== false) {
        //if (preg_match('/\d{2}-\d{2}-\d{4}/', $d1)) {
            // Verificar si la fecha es válida
            //$d = DateTime::createFromFormat('d-m-Y', $d1);

            //return $d && $d->format('d-m-Y') === $d1;
            return $d->format('d-m-Y');
        } else {
            $this->form_validation->set_message('valid_date', 'El campo {field} debe contener una fecha válida en formato dd/mm/yyyy.');
            return FALSE;
        }
    }


	public function edit($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}
		$_SESSION['identificador'] = $gid;
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proyectos_edit'), 'proyectos/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		

		/* Variables *///Trae de la base de datos la fila seleccionada
		$colonia = $this->Proyectos_model->view('proyectos', array('gid' => $gid))->row();
		//$colonia = $this->Proyectos_model->view('proyectos', array('' => ))->row();
		$this->data['documentos'] = $this->Tumba_model->get_documents_by_project($gid,'1');
		if (isset($_POST['importar']) && !empty($_FILES['importar_documentos']['name'][0])) {
			$upload_path = 'C:/dir_ema/archivos/proyectos/' . $gid . '/';
	
			// Crear la carpeta si no existe
			if (!is_dir($upload_path)) {
				mkdir($upload_path, 0777, true);
			}
			$tipo_documento = '1';
			// Llamar al modelo para subir archivos
			$upload_result = $this->Tumba_model->upload_documents('importar_documentos', $upload_path, $gid,$tipo_documento);
	
			if ($upload_result['status']) {
				$this->session->set_flashdata('message', 'Documentos importados correctamente.');
			} else {
				$this->session->set_flashdata('error', implode('<br>', $upload_result['errors']));
			}
	
			redirect(current_url()); // Redirigir para evitar doble envío del formulario
		}
        // Definir reglas de validación
        //$this->form_validation->set_rules('col_cod', $this->lang->line('edit_colonia_validation_name_label'), 'required|is_numeric|max_length[3]');
		//$this->form_validation->set_rules('nombre', $this->lang->line('edit_colonia_validation_name_label'), 'required');
		$this->form_validation->set_rules('nombre', 'lang:proyectos_nombre', 'required|max_length[100]');
		$this->form_validation->set_rules('fecha_inicio', 'Fecha Inicio', 'trim');
		$this->form_validation->set_rules('fecha_final', 'Fecha Final', 'trim');
		$this->form_validation->set_rules('fecha_registro', 'Fecha Registro', 'trim');
		$this->form_validation->set_rules(
			'codigo',
			lang('proyectos_codigo'),
			'required|max_length[10]|regex_match[/^([A-Z]{1,3}[0-9]{1,7})?$/]',
			array(
				'regex_match' => 'El campo {field} debe comenzar con letras mayúsculas y contener hasta 3 dígitos, seguido de hasta 7 números.'
			)
		);

		$this->form_validation->set_rules('actividad', 'Actividad', 'max_length[200]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} no debe superar los 200 caracteres.')
		);

		$this->form_validation->set_rules('id_grupoproyecto', 'Grupo Proyecto', 'max_length[1]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} solo puede contener 1 caracter.')
		);

		$this->form_validation->set_rules('coor_x', 'Coordenada X', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('coor_y', 'Coordenada Y', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('col_cod', 'Código de Colonia', 'integer', 
			array('required' => 'El campo {field} es obligatorio.', 'integer' => 'El campo {field} debe ser un número entero.')
		);

		$this->form_validation->set_rules('exp_gestion', 'Expediente de Gestión', 'numeric|exact_length[4]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'exact_length' => 'El campo {field} debe tener exactamente 4 dígitos.')
		);

		$this->form_validation->set_rules('exp_numero', 'Número de Expediente', 'numeric|max_length[7]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'max_length' => 'El campo {field} no debe superar los 7 dígitos.')
		);
		$this->form_validation->set_rules('tipo_estudio', 'Tipo de Estudio', 'max_length[100]');
		$this->form_validation->set_rules('tipo_proyecto', 'Tipo de Proyecto', 'max_length[100]');
		$this->form_validation->set_rules('dpto', 'Departamento', 'max_length[100]');
		$this->form_validation->set_rules('distrito', 'Distrito', 'max_length[100]');
		$this->form_validation->set_rules('localidad', 'Localidad', 'max_length[100]');
		$this->form_validation->set_rules('barrio', 'Barrio', 'max_length[100]');
		$this->form_validation->set_rules('sector_proyecto', 'Sector Proyecto', 'max_length[100]');


		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{	
			
				if ($_POST['expediente']) {
					$arraycampos['expediente']   	= strtoupper($_POST['expediente']);
				}

				if ($_POST['codigo']) {
					$arraycampos['codigo']   			= strtoupper($_POST['codigo']);
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']			    = strtoupper($_POST['nombre']);
				}

				if ($_POST['dp_consultores']) {
					$arraycampos['id_consultor']		= $_POST['dp_consultores'];
				}else{
					$arraycampos['id_consultor']		= 	NULL;
				}

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}

				if ($_POST['dp_clientes']) {
					$arraycampos['id_proponente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_proponente']		= 	NULL;
				}

				if ($_POST['fecha_inicio']) {
					$arraycampos['fecha_inicio']		= $_POST['fecha_inicio'];
				}else{
					$arraycampos['fecha_inicio']		= NULL;
				}

				if ($_POST['fecha_final']) {
					$arraycampos['fecha_final']			= $_POST['fecha_final'];
				}else{
					$arraycampos['fecha_final']			= NULL;
				}				

				if ($_POST['fecha_registro']) {
					$arraycampos['fecha_registro']		= $_POST['fecha_registro'];
				}else{
					$arraycampos['fecha_registro']		= NULL;
				}



				if ($_POST['descripcion']) {
					$arraycampos['descripcion']			= trim($_POST['descripcion']);
				}else{
					$arraycampos['descripcion']			= '';
				}

				if ($_POST['padron']) {
					$arraycampos['padron']			    = strtoupper($_POST['padron']);
				}

				if ($_POST['cta_cte']) {
					$arraycampos['cta_cte']			    = strtoupper($_POST['cta_cte']);
				}


				if ($_POST['dp_estado']) {
					$arraycampos['estado']				= $_POST['dp_estado'];
				}else{
					$arraycampos['estado']				= 	NULL;
				}

				if ($_POST['expediente_hidrico']) {
					$arraycampos['expediente_hidrico']   	= strtoupper($_POST['expediente_hidrico']);
				}

				if ($_POST['finca']) {
					$arraycampos['finca']			    = strtoupper($_POST['finca']);
				}

				if ($_POST['matricula']) {
					$arraycampos['matricula']			    = strtoupper($_POST['matricula']);
				}
				/* if ($_POST['actividad']) {
					$arraycampos['actividad'] = strtoupper($_POST['actividad']);
				} */

				if ($_POST['dp_actividad']) {
					$arraycampos['actividad']		= $_POST['dp_actividad'];
				}else{
					$arraycampos['actividad']		= 	NULL;
				}

	
				/*if ($_POST['dp_grupo_proyecto']) {
					$arraycampos['id_grupoproyecto'] = $_POST['dp_grupo_proyecto'];
				}else{
					$arraycampos['id_grupoproyecto']	= 	NULL;
				}*/
	
				if ($_POST['coor_x']) {
					$arraycampos['coor_x'] = $_POST['coor_x'];
				}else{
					$arraycampos['coor_x']		= 	NULL;
				}
	
				if ($_POST['coor_y']) {
					$arraycampos['coor_y'] = $_POST['coor_y'];
				}else{
					$arraycampos['coor_y']		= 	NULL;
				}
	
				/*if ($_POST['col_cod']) {
					$arraycampos['col_cod'] = strtoupper($_POST['col_cod']);
				}else{
					$arraycampos['col_cod']		= 	NULL;
				}*/

				/*if ($_POST['exp_gestion']) {
					$arraycampos['exp_gestion'] = strtoupper($_POST['exp_gestion']);
				}else{
					$arraycampos['exp_gestion']		= 	NULL;
				}
	
				if ($_POST['exp_numero']) {
					$arraycampos['exp_numero'] = strtoupper($_POST['exp_numero']);
				}else{
					$arraycampos['exp_numero']		= 	NULL;
				}*/

				if ($_POST['dp_tipo_estudio']) {
					$arraycampos['tipo_estudio'] = strtoupper($_POST['dp_tipo_estudio']);
				}
		
				if ($_POST['dp_tipo_proyecto']) {
					$arraycampos['tipo_proyecto'] = strtoupper($_POST['dp_tipo_proyecto']);
				}
		
				if ($_POST['dp_dpto']) {
					$arraycampos['dpto'] = strtoupper($_POST['dp_dpto']);
				}
		
				if ($_POST['dp_distrito']) {
					$arraycampos['distrito'] = strtoupper($_POST['dp_distrito']);
				}
		
				if ($_POST['barloc']) {
					$arraycampos['localidad'] = strtoupper($_POST['barloc']);
				}
		
				if ($_POST['barloc']) {
					$arraycampos['barrio'] = strtoupper($_POST['barloc']);
				}

				if ($_POST['dp_sector']) {
					$arraycampos['sector_proyecto'] = strtoupper($_POST['dp_sector']);
				}



				$colonia_update = $this->Proyectos_model->update_colonia($gid, $arraycampos);

				if ($colonia_update) {
					// Si la actualización fue exitosa
					$this->session->set_flashdata('message', '✅ El proyecto ha sido actualizado correctamente.');
					redirect('man_espacial/proyectos/proyectos/edit/' . $gid);
				} else {
					// Si no hubo cambios en la actualización
					$this->session->set_flashdata('message', '⚠ No se realizaron cambios en el proyecto.');
					redirect('man_espacial/proyectos/proyectos/edit/' . $gid);
				}
			} else {
				// Si la validación de formulario falla
				$this->session->set_flashdata('message', '❌ Error en la validación del formulario. Revisa los campos.');
				redirect('man_espacial/proyectos/proyectos/edit/' . $gid);
			}
		}


        
       		$proyecto_a = $this->Proyectos_model->view('proyectos', array('gid' => $gid))->row();


			   $arraycampos['gid']    				= $proyecto_a->gid;
			   $arraycampos['expediente']   		= $proyecto_a->expediente;
			   $arraycampos['codigo']   			= $proyecto_a->codigo;
			   $arraycampos['nombre']			    = $proyecto_a->nombre;
			   $arraycampos['id_consultor']			= $proyecto_a->id_consultor;
			   $arraycampos['id_proponente']		= $proyecto_a->id_proponente;
			   $arraycampos['id_cliente']			= $proyecto_a->id_cliente;
			   $arraycampos['fecha_inicio']			= $proyecto_a->fecha_inicio;
			   $arraycampos['fecha_final']			= $proyecto_a->fecha_final;
			   $arraycampos['fecha_registro']		= $proyecto_a->fecha_registro;
			   $arraycampos['descripcion']			= $proyecto_a->descripcion;
			   $arraycampos['padron']			    = $proyecto_a->padron;
			   $arraycampos['cta_cte']			    = $proyecto_a->cta_cte;
			   $arraycampos['estado']				= $proyecto_a->estado;
			   $arraycampos['expediente_hidrico']	= $proyecto_a->expediente_hidrico;
			   $arraycampos['finca']			    = $proyecto_a->finca;
			   $arraycampos['matricula']			= $proyecto_a->matricula;
			   $arraycampos['tipo_estudio']			= $proyecto_a->tipo_estudio;
			   $arraycampos['tipo_proyecto']		= $proyecto_a->tipo_proyecto;
			   $arraycampos['dpto']					= $proyecto_a->dpto;
			   $arraycampos['distrito']				= $proyecto_a->distrito;
			   $arraycampos['localidad']			= $proyecto_a->localidad;
			   $arraycampos['barrio']				= $proyecto_a->barrio;
			   $arraycampos['actividad']           	= $proyecto_a->actividad;
			   //$arraycampos['id_grupoproyecto']    	= $proyecto_a->id_grupoproyecto;
			   $arraycampos['coor_x']              	= $proyecto_a->coor_x;
			   $arraycampos['coor_y']              	= $proyecto_a->coor_y;
			   $arraycampos['col_cod']             	= $proyecto_a->col_cod;
			   $arraycampos['exp_gestion']         	= $proyecto_a->exp_gestion;
			   $arraycampos['exp_numero']          	= $proyecto_a->exp_numero;
			   $arraycampos['sector_proyecto']     	= $proyecto_a->sector_proyecto;
			   
			$_SESSION['identificador']				= $proyecto_a->gid;
        
            $_SESSION['arraycampos'] 				= $arraycampos;


            $decode_ema_a = $this->Proyectos_model->view('v_proyectos_index', array('gid' => $gid))->row();
	

					$decode_ema['nombre_decode']			= $decode_ema_a->nombre_decode;
					$decode_ema['consultor_decode']			= $decode_ema_a->consultor_decode;
					$decode_ema['proponente_decode']		= $decode_ema_a->proponente_decode;


			$_SESSION['decode_ema'] =$decode_ema; 	

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		$this->data['colonia']   = $colonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->nombre ? 'readonly' : '';
		
		//creando campos
		$this->data['expediente'] = array(
			'name'  => 'expediente',
			'id'    => 'expediente',
			'type'  => 'text',
			'placeholder'  =>  '9999999/9999',
			'pattern'  => '^[0-9]{1,7}/[0-9]{1,4}$',
			'maxlength' => '12',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('expediente', $colonia->expediente),
		);	

		$this->data['codigo'] = array(
			'name'  => 'codigo',
			'id'    => 'codigo',
			'type'  => 'text',
			'placeholder'  =>  'XXX9999999',
			'pattern'  => '^[A-Z]{1,3}[0-9]{1,7}$',
			'maxlength' => '10',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('codigo', $colonia->codigo),
		);
		 
		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $colonia->nombre),
			'data-src' => $colonia->nombre,
			'class'    => 'form-control'
		);

		$this->data['descripcion'] = array(
			'type'  => 'text',
			'name'  => 'descripcion',
			'id'    => 'descripcion',
			'style' => 'width: 100%;height: 50%',
			'value'    => $this->form_validation->set_value('descripcion', $colonia->descripcion),
			'class' => 'form-control'
		);
		$this->data['padron'] = array(
			'name'  => 'padron',
			'id'    => 'padron',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('padron', $colonia->padron),
		);
		$this->data['cta_cte'] = array(
			'name'  => 'cta_cte',
			'id'    => 'cta_cte',
			'type'  => 'text',
			'placeholder'  =>  '99-9999-99',
			'pattern'  => '^[0-9]{1,2}-[0-9]{1,4}-[0-9]{1,2}$',
			'maxlength' => '10',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('cta_cte', $colonia->cta_cte),
		);	
		
		$this->data['fecha_inicio'] = array(
			'type'     => 'text',
			'name'     => 'fecha_inicio',
			'id'       => 'fecha_inicio',
			//'value'    => $this->form_validation->set_value('fecha_inicio', trim($colonia->fecha_inicio)),
			'value'    => $this->form_validation->set_value('fecha_inicio', formato_fecha($colonia->fecha_inicio)),
			'class'    => 'form-control'
			);

		$this->data['fecha_final'] = array(
			'type'     => 'text',
			'name'     => 'fecha_final',
			'id'       => 'fecha_final',
			//'value'    => $this->form_validation->set_value('fecha_final', trim($colonia->fecha_final)),
			'value'    => $this->form_validation->set_value('fecha_final', formato_fecha($colonia->fecha_final)),
			'class'    => 'form-control'
			);


		$this->data['fecha_registro'] = array(
			'type'     => 'text',
			'name'     => 'fecha_registro',
			'id'       => 'fecha_registro',
			//'value'    => $this->form_validation->set_value('fecha_registro', trim($colonia->fecha_registro)),
			'value'    => $this->form_validation->set_value('fecha_registro', formato_fecha($colonia->fecha_registro)),
			'class'    => 'form-control'
			);

		$this->data['expediente_hidrico'] = array(
			'name'  => 'expediente_hidrico',
			'id'    => 'expediente_hidrico',
			'type'  => 'text',
			'placeholder'  =>  '9999999/9999',
			'pattern'  => '^[0-9]{1,7}/[0-9]{1,4}$',
			'maxlength' => '12',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('expediente_hidrico', $colonia->expediente_hidrico),
		);	
		$this->data['finca'] = array(
			'name'  => 'finca',
			'id'    => 'finca',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('finca', $colonia->finca),
		);	

		$this->data['matricula'] = array(
			'name'  => 'matricula',
			'id'    => 'matricula',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('matricula', $colonia->matricula),
		);	

		
		$this->data['distrito'] = array(
			'name' => 'distrito',
			'id' => 'distrito',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('distrito', $colonia->distrito),
		);
		
		$this->data['localidad'] = array(
			'name' => 'localidad',
			'id' => 'localidad',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('localidad', $colonia->localidad),
		);
		
		$this->data['barrio'] = array(
			'name' => 'barrio',
			'id' => 'barrio',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('barrio', $colonia->barrio),
		);

		/* $this->data['actividad'] = array(
			'name'  => 'actividad',
			'id'    => 'actividad',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('actividad', $colonia->actividad),
		); */
	
		$this->data['id_grupoproyecto'] = array(
			'name'  => 'id_grupoproyecto',
			'id'    => 'id_grupoproyecto',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('id_grupoproyecto', $colonia->id_grupoproyecto),
		);

	

	
		$this->data['coor_x'] = array(
			'name'  => 'coor_x',
			'id'    => 'coor_x',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('coor_x', $colonia->coor_x),
		);
	
		$this->data['coor_y'] = array(
			'name'  => 'coor_y',
			'id'    => 'coor_y',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('coor_y', $colonia->coor_y),
		);
	
		$this->data['col_cod'] = array(
			'name'  => 'col_cod',
			'id'    => 'col_cod',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('col_cod', $colonia->col_cod),
		);
	
		$this->data['exp_gestion'] = array(
			'name'  => 'exp_gestion',
			'id'    => 'exp_gestion',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('exp_gestion', $colonia->exp_gestion),
		);
	
		$this->data['exp_numero'] = array(
			'name'  => 'exp_numero',
			'id'    => 'exp_numero',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('exp_numero', $colonia->exp_numero),
		);


		$a_consultores[''] = 'Seleccione el Consultor';
		$d_consultores = $this->Proyectos_model->dropdown_data('consultores')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_consultores as $r_consultor) {
			$a_consultores[$r_consultor['id_consultor']] = $r_consultor['id_consultor'].' - '.$r_consultor['nombre'].' '.$r_consultor['apellido'];
		}
		$this->data['consultores'] = $a_consultores;
		$this->data['consultores_sel'] = $colonia->id_consultor;

		$a_proponentes[''] = 'Seleccione el Proponente';
		$d_proponentes = $this->Proyectos_model->dropdown_data('proponentes')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_proponentes as $r_proponente) {
			$a_proponentes[$r_proponente['id_proponente']] = $r_proponente['id_proponente'].' - '.$r_proponente['nombre'].' '.$r_proponente['apellido'];
		}
		$this->data['proponentes'] = $a_proponentes;
		$this->data['proponentes_sel'] = $colonia->id_proponente;

		$a_clientes[''] = 'Seleccione el Proponentes';
		$d_clientes = $this->Proyectos_model->dropdown_data('cliente')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_clientes as $r_cliente) {
			$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
		}
		$this->data['cliente'] = $a_clientes;
		$this->data['cliente_sel'] = $colonia->id_cliente;

		$a_tipo_estudio[''] = 'Seleccione Tipo de Estudio';
		$d_tipo_estudio = $this->Proyectos_model->concepto('TIPO_ESTUDIO',false,'CONCEPTO')->result_array();
		foreach ($d_tipo_estudio as $r_tipo_estudio) {
			$a_tipo_estudio[$r_tipo_estudio['concepto']] = $r_tipo_estudio['concepto'].' - '.$r_tipo_estudio['nombre'];
		}
		$this->data['tipo_estudio'] = $a_tipo_estudio;
		if (isset($colonia->tipo_estudio)) {
			$this->data['tipo_estudio_sel'] = $colonia->tipo_estudio;
		} else {
			$this->data['tipo_estudio_sel'] = null;  // O cualquier valor por defecto
		}

		$a_tipo_proyecto[''] = 'Seleccione Tipo de Proyecto';
		$d_tipo_proyecto = $this->Proyectos_model->concepto('TIPO_PROYECTO',false,'CONCEPTO')->result_array();
		foreach ($d_tipo_proyecto as $r_tipo_proyecto) {
			$a_tipo_proyecto[$r_tipo_proyecto['concepto']] = $r_tipo_proyecto['nombre'];
		}
		$this->data['tipo_proyecto'] = $a_tipo_proyecto;
		$this->data['tipo_proyecto_sel'] = $colonia->tipo_proyecto;

		// Obtener el grupo de proyectos desde el modelo
		$a_grupo_proyecto[''] = 'Seleccione Grupo Proyecto';
		$d_grupo_proyecto = $this->Proyectos_model->concepto('GRUPO_PROYECTO',false,'CONCEPTO')->result_array();
		foreach ($d_grupo_proyecto as $r_grupo_proyecto) {
			$a_grupo_proyecto[$r_grupo_proyecto['concepto']] = $r_grupo_proyecto['nombre'];
		}
		$this->data['grupo_proyecto'] = $a_grupo_proyecto;
		$this->data['grupo_proyecto_sel'] = isset($colonia->id_grupoproyecto) ? $colonia->id_grupoproyecto : null;  // Valor seleccionado

		// Obtener el sector de proyectos desde el modelo
		$a_sector[''] = 'Seleccione Sector';
		$d_sector = $this->Proyectos_model->concepto('SECTORE_PROYECTOS',false,'CONCEPTO')->result_array();
		foreach ($d_sector as $r_sector) {
			$a_sector[$r_sector['concepto']] = $r_sector['nombre'];
		}
		$this->data['sector'] = $a_sector;
		$this->data['sector_sel'] = isset($colonia->sector_proyecto) ? $colonia->sector_proyecto : null;  // Valor seleccionado

				


		

		

		$a_estado[''] = 'Seleccione Estado';
		$d_estado = $this->Proyectos_model->concepto('PROYECTO_ESTADO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_estado as $r_estado) {
			$a_estado[$r_estado['concepto']] = $r_estado['concepto'].' - '.$r_estado['nombre'];
		}
		$this->data['estado'] = $a_estado;
		$this->data['estado_sel'] = $colonia->estado;

		$a_dpto[''] = 'Seleccione el Departamento';
		$d_dpto = $this->Proyectos_model->dropdown_data('dpto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_dpto as $r_dpto) {
			$a_dpto[$r_dpto['dpto']] = $r_dpto['dpto'].' - '.$r_dpto['dpto_desc'];
		}
		$this->data['dpto'] = $a_dpto;
		$this->data['dpto_sel'] = $colonia->dpto;

		$a_distrito[''] = 'Seleccione el Distrito';
		$d_distrito = $this->Proyectos_model->dropdown_data('distritos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_distrito as $r_distrito) {
			$a_distrito[$r_distrito['distrito']] = $r_distrito['distrito'].' - '.$r_distrito['dist_desc'];
		}
		$this->data['distrito'] = $a_distrito;
		$this->data['distrito_sel'] = $colonia->distrito;

		$a_barloc[''] = 'Seleccione el Barrio';
		// Obtener solo los barrios que pertenecen al departamento y distrito seleccionados
		$d_barloc = $this->Proyectos_model->get_barloc_by_distrito($colonia->dpto, $colonia->distrito);

		foreach ($d_barloc as $r_barloc) {
			$a_barloc[$r_barloc->id] = $r_barloc->id.' - '.$r_barloc->barlo_desc;
		}

		$this->data['barloc'] = $a_barloc;
		$this->data['barloc_sel'] = $colonia->barrio;

		// Actividades dropdown
		$a_actividad[''] = 'Seleccione la actividad';
		$d_actividades = $this->Proyectos_model->dropdown_data('actividades')->result_array();

		foreach ($d_actividades as $r_actividad) {
			$a_actividad[$r_actividad['id']] = $r_actividad['id'] . ' - ' . $r_actividad['descripcion'];
		}
		$this->data['actividad'] = $a_actividad;
		$this->data['actividad_sel'] = isset($colonia->actividad) ? $colonia->actividad : null;


		
		
		/* echo '<pre>';
		print_r($colonia);
		echo '</pre>';
		exit; 
		 */

		
			

		
		


		//* ------------------------------------------------------------------- */
		/* Load Template */
		$this->template->admin_render('man_espacial/proyectos/edit', $this->data);
	}

	public function delete_document($id_documento, $tipo_documento = '1') {
		// Obtener el ID del proyecto asociado al documento
		$proyecto = $this->Tumba_model->get_project_by_document($id_documento, $tipo_documento);
	
		if ($this->Tumba_model->delete_document($id_documento, $tipo_documento)) {
			$this->session->set_flashdata('message', 'Documento eliminado correctamente.');
		} else {
			$this->session->set_flashdata('error', 'No se pudo eliminar el documento. Verifica el tipo de documento.');
		}
	
		// Verificar si se encontró el proyecto y redirigir correctamente
		if ($proyecto) {
			redirect('man_espacial/proyectos/proyectos/edit/' . $proyecto->id_documento);
		} else {
			redirect('man_espacial/proyectos/proyectos'); // Redirigir a la lista de proyectos si no hay ID de proyecto
		}
	}

/// ver nuevo

	public function ver($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proyectos_edit'), 'proyectos/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		

		/* Variables *///Trae de la base de datos la fila seleccionada
		$colonia = $this->Proyectos_model->view('proyectos', array('gid' => $gid))->row();
		//$colonia = $this->Proyectos_model->view('proyectos', array('' => ))->row();
		$this->data['documentos'] = $this->Tumba_model->get_documents_by_project($gid,'1');
		if (isset($_POST['importar']) && !empty($_FILES['importar_documentos']['name'][0])) {
			$upload_path = 'C:/dir_ema/archivos/proyectos/' . $gid . '/';
	
			// Crear la carpeta si no existe
			if (!is_dir($upload_path)) {
				mkdir($upload_path, 0777, true);
			}
			$tipo_documento = '1';
			// Llamar al modelo para subir archivos
			$upload_result = $this->Tumba_model->upload_documents('importar_documentos', $upload_path, $gid,$tipo_documento);
	
			if ($upload_result['status']) {
				$this->session->set_flashdata('message', 'Documentos importados correctamente.');
			} else {
				$this->session->set_flashdata('error', implode('<br>', $upload_result['errors']));
			}
	
			redirect(current_url()); // Redirigir para evitar doble envío del formulario
		}
        // Definir reglas de validación
        //$this->form_validation->set_rules('col_cod', $this->lang->line('edit_colonia_validation_name_label'), 'required|is_numeric|max_length[3]');
		//$this->form_validation->set_rules('nombre', $this->lang->line('edit_colonia_validation_name_label'), 'required');
		$this->form_validation->set_rules('nombre', 'lang:proyectos_nombre', 'required|max_length[100]');
		$this->form_validation->set_rules('fecha_inicio', 'Fecha Inicio', 'trim');
		$this->form_validation->set_rules('fecha_final', 'Fecha Final', 'trim');
		$this->form_validation->set_rules('fecha_registro', 'Fecha Registro', 'trim');
		$this->form_validation->set_rules(
			'codigo',
			lang('proyectos_codigo'),
			'required|max_length[10]|regex_match[/^([A-Z]{1,3}[0-9]{1,7})?$/]',
			array(
				'regex_match' => 'El campo {field} debe comenzar con letras mayúsculas y contener hasta 3 dígitos, seguido de hasta 7 números.'
			)
		);

		$this->form_validation->set_rules('actividad', 'Actividad', 'max_length[200]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} no debe superar los 200 caracteres.')
		);

		$this->form_validation->set_rules('id_grupoproyecto', 'Grupo Proyecto', 'max_length[1]', 
			array('required' => 'El campo {field} es obligatorio.', 'max_length' => 'El campo {field} solo puede contener 1 caracter.')
		);

		$this->form_validation->set_rules('coor_x', 'Coordenada X', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('coor_y', 'Coordenada Y', 'decimal|greater_than[0]|max_length[12]', 
			array('required' => 'El campo {field} es obligatorio.', 'decimal' => 'El campo {field} debe ser un número decimal.', 'greater_than' => 'El valor de {field} debe ser mayor que 0.')
		);

		$this->form_validation->set_rules('col_cod', 'Código de Colonia', 'integer', 
			array('required' => 'El campo {field} es obligatorio.', 'integer' => 'El campo {field} debe ser un número entero.')
		);

		$this->form_validation->set_rules('exp_gestion', 'Expediente de Gestión', 'numeric|exact_length[4]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'exact_length' => 'El campo {field} debe tener exactamente 4 dígitos.')
		);

		$this->form_validation->set_rules('exp_numero', 'Número de Expediente', 'numeric|max_length[7]', 
			array('required' => 'El campo {field} es obligatorio.', 'numeric' => 'El campo {field} debe ser numérico.', 'max_length' => 'El campo {field} no debe superar los 7 dígitos.')
		);
		$this->form_validation->set_rules('tipo_estudio', 'Tipo de Estudio', 'max_length[100]');
		$this->form_validation->set_rules('tipo_proyecto', 'Tipo de Proyecto', 'max_length[100]');
		$this->form_validation->set_rules('dpto', 'Departamento', 'max_length[100]');
		$this->form_validation->set_rules('distrito', 'Distrito', 'max_length[100]');
		$this->form_validation->set_rules('localidad', 'Localidad', 'max_length[100]');
		$this->form_validation->set_rules('barrio', 'Barrio', 'max_length[100]');
		$this->form_validation->set_rules('sector_proyecto', 'Sector Proyecto', 'max_length[100]');


		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{	
			
				if ($_POST['expediente']) {
					$arraycampos['expediente']   	= strtoupper($_POST['expediente']);
				}

				if ($_POST['codigo']) {
					$arraycampos['codigo']   			= strtoupper($_POST['codigo']);
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']			    = strtoupper($_POST['nombre']);
				}

				if ($_POST['dp_consultores']) {
					$arraycampos['id_consultor']		= $_POST['dp_consultores'];
				}else{
					$arraycampos['id_consultor']		= 	NULL;
				}

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}

				if ($_POST['dp_proponentes']) {
					$arraycampos['id_proponente']		= $_POST['dp_proponentes'];
				}else{
					$arraycampos['id_proponente']		= 	NULL;
				}

				if ($_POST['fecha_inicio']) {
					$arraycampos['fecha_inicio']		= $_POST['fecha_inicio'];
				}else{
					$arraycampos['fecha_inicio']		= NULL;
				}

				if ($_POST['fecha_final']) {
					$arraycampos['fecha_final']			= $_POST['fecha_final'];
				}else{
					$arraycampos['fecha_final']			= NULL;
				}				

				if ($_POST['fecha_registro']) {
					$arraycampos['fecha_registro']		= $_POST['fecha_registro'];
				}else{
					$arraycampos['fecha_registro']		= NULL;
				}



				if ($_POST['descripcion']) {
					$arraycampos['descripcion']			= trim($_POST['descripcion']);
				}else{
					$arraycampos['descripcion']			= '';
				}

				if ($_POST['padron']) {
					$arraycampos['padron']			    = strtoupper($_POST['padron']);
				}

				if ($_POST['cta_cte']) {
					$arraycampos['cta_cte']			    = strtoupper($_POST['cta_cte']);
				}


				if ($_POST['dp_estado']) {
					$arraycampos['estado']				= $_POST['dp_estado'];
				}else{
					$arraycampos['estado']				= 	NULL;
				}

				if ($_POST['expediente_hidrico']) {
					$arraycampos['expediente_hidrico']   	= strtoupper($_POST['expediente_hidrico']);
				}

				if ($_POST['finca']) {
					$arraycampos['finca']			    = strtoupper($_POST['finca']);
				}

				if ($_POST['matricula']) {
					$arraycampos['matricula']			    = strtoupper($_POST['matricula']);
				}
				if ($_POST['actividad']) {
					$arraycampos['actividad'] = strtoupper($_POST['actividad']);
				}
	
				if ($_POST['dp_grupo_proyecto']) {
					$arraycampos['id_grupoproyecto'] = $_POST['dp_grupo_proyecto'];
				}
	
				if ($_POST['coor_x']) {
					$arraycampos['coor_x'] = $_POST['coor_x'];
				}
	
				if ($_POST['coor_y']) {
					$arraycampos['coor_y'] = $_POST['coor_y'];
				}
	
				if ($_POST['col_cod']) {
					$arraycampos['col_cod'] = strtoupper($_POST['col_cod']);
				}
	
				if ($_POST['exp_gestion']) {
					$arraycampos['exp_gestion'] = strtoupper($_POST['exp_gestion']);
				}
	
				if ($_POST['exp_numero']) {
					$arraycampos['exp_numero'] = strtoupper($_POST['exp_numero']);
				}
				if ($_POST['dp_tipo_estudio']) {
					$arraycampos['tipo_estudio'] = strtoupper($_POST['dp_tipo_estudio']);
				}
		
				if ($_POST['dp_tipo_proyecto']) {
					$arraycampos['tipo_proyecto'] = strtoupper($_POST['dp_tipo_proyecto']);
				}
		
				if ($_POST['dp_dpto']) {
					$arraycampos['dpto'] = strtoupper($_POST['dp_dpto']);
				}
		
				if ($_POST['dp_distrito']) {
					$arraycampos['distrito'] = strtoupper($_POST['dp_distrito']);
				}
		
				if ($_POST['barloc']) {
					$arraycampos['localidad'] = strtoupper($_POST['barloc']);
				}
		
				if ($_POST['barloc']) {
					$arraycampos['barrio'] = strtoupper($_POST['barloc']);
				}

				if ($_POST['dp_sector']) {
					$arraycampos['sector_proyecto'] = strtoupper($_POST['dp_sector']);
				}



				$colonia_update = $this->Proyectos_model->update_colonia($gid,$arraycampos);

				if ($colonia_update)
				{

					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_colonia_saved') por $_POST('id') por ejemplo
					$this->session->set_flashdata('message', $this->lang->line('colonia_update_successful'));
					redirect('man_espacial/proyectos/proyectos/edit/'.$gid); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/proyectos/proyectos', 'refresh'); 
			}
		}


        
       		$proyecto_a = $this->Proyectos_model->view('proyectos', array('gid' => $gid))->row();


			   $arraycampos['gid']    				= $proyecto_a->gid;
			   $arraycampos['expediente']   		= $proyecto_a->expediente;
			   $arraycampos['codigo']   			= $proyecto_a->codigo;
			   $arraycampos['nombre']			    = $proyecto_a->nombre;
			   $arraycampos['id_consultor']			= $proyecto_a->id_consultor;
			   $arraycampos['id_proponente']		= $proyecto_a->id_proponente;
			   $arraycampos['id_cliente']			= $proyecto_a->id_cliente;
			   $arraycampos['fecha_inicio']			= $proyecto_a->fecha_inicio;
			   $arraycampos['fecha_final']			= $proyecto_a->fecha_final;
			   $arraycampos['fecha_registro']		= $proyecto_a->fecha_registro;
			   $arraycampos['descripcion']			= $proyecto_a->descripcion;
			   $arraycampos['padron']			    = $proyecto_a->padron;
			   $arraycampos['cta_cte']			    = $proyecto_a->cta_cte;
			   $arraycampos['estado']				= $proyecto_a->estado;
			   $arraycampos['expediente_hidrico']	= $proyecto_a->expediente_hidrico;
			   $arraycampos['finca']			    = $proyecto_a->finca;
			   $arraycampos['matricula']			= $proyecto_a->matricula;
			   $arraycampos['tipo_estudio']			= $proyecto_a->tipo_estudio;
			   $arraycampos['tipo_proyecto']		= $proyecto_a->tipo_proyecto;
			   $arraycampos['dpto']					= $proyecto_a->dpto;
			   $arraycampos['distrito']				= $proyecto_a->distrito;
			   $arraycampos['localidad']			= $proyecto_a->localidad;
			   $arraycampos['barrio']				= $proyecto_a->barrio;
			   $arraycampos['actividad']           	= $proyecto_a->actividad;
			   $arraycampos['id_grupoproyecto']    	= $proyecto_a->id_grupoproyecto;
			   $arraycampos['coor_x']              	= $proyecto_a->coor_x;
			   $arraycampos['coor_y']              	= $proyecto_a->coor_y;
			   $arraycampos['col_cod']             	= $proyecto_a->col_cod;
			   $arraycampos['exp_gestion']         	= $proyecto_a->exp_gestion;
			   $arraycampos['exp_numero']          	= $proyecto_a->exp_numero;
			   $arraycampos['sector_proyecto']     	= $proyecto_a->sector_proyecto;
			   
			$_SESSION['identificador']				= $proyecto_a->gid;
        
            $_SESSION['arraycampos'] 				= $arraycampos;


            $decode_ema_a = $this->Proyectos_model->view('v_proyectos_index', array('gid' => $gid))->row();
	

					$decode_ema['nombre_decode']			= $decode_ema_a->nombre_decode;
					$decode_ema['consultor_decode']			= $decode_ema_a->consultor_decode;
					$decode_ema['proponente_decode']		= $decode_ema_a->proponente_decode;


			$_SESSION['decode_ema'] =$decode_ema; 	

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		$this->data['colonia']   = $colonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->nombre ? 'readonly' : '';
		
		//creando campos
		$this->data['expediente'] = array(
			'name'  => 'expediente',
			'id'    => 'expediente',
			'type'  => 'text',
			'placeholder'  =>  '9999999/9999',
			'pattern'  => '^[0-9]{1,7}/[0-9]{1,4}$',
			'maxlength' => '12',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('expediente', $colonia->expediente),
			'readonly' => 'readonly'
		);	

		$this->data['codigo'] = array(
			'name'  => 'codigo',
			'id'    => 'codigo',
			'type'  => 'text',
			'placeholder'  =>  'XXX9999999',
			'pattern'  => '^[A-Z]{1,3}[0-9]{1,7}$',
			'maxlength' => '10',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('codigo', $colonia->codigo),
			'readonly' => 'readonly'
		);
		 
		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $colonia->nombre),
			'data-src' => $colonia->nombre,
			'class'    => 'form-control',
			'readonly' => 'readonly'
		);

		$this->data['descripcion'] = array(
			'type'  => 'text',
			'name'  => 'descripcion',
			'id'    => 'descripcion',
			'style' => 'width: 100%;height: 50%',
			'value'    => $this->form_validation->set_value('descripcion', $colonia->descripcion),
			'class' => 'form-control',
			'readonly' => 'readonly'
		);
		$this->data['padron'] = array(
			'name'  => 'padron',
			'id'    => 'padron',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('padron', $colonia->padron),
			'readonly' => 'readonly'
		);
		$this->data['cta_cte'] = array(
			'name'  => 'cta_cte',
			'id'    => 'cta_cte',
			'type'  => 'text',
			'placeholder'  =>  '99-9999-99',
			'pattern'  => '^[0-9]{1,2}-[0-9]{1,4}-[0-9]{1,2}$',
			'maxlength' => '10',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('cta_cte', $colonia->cta_cte),
			'readonly' => 'readonly'
		);	
		
		$this->data['fecha_inicio'] = array(
			'type'     => 'text',
			'name'     => 'fecha_inicio',
			'id'       => 'fecha_inicio',
			//'value'    => $this->form_validation->set_value('fecha_inicio', trim($colonia->fecha_inicio)),
			'value'    => $this->form_validation->set_value('fecha_inicio', formato_fecha($colonia->fecha_inicio)),
			'class'    => 'form-control',
			'readonly' => 'readonly'
			);

		$this->data['fecha_final'] = array(
			'type'     => 'text',
			'name'     => 'fecha_final',
			'id'       => 'fecha_final',
			//'value'    => $this->form_validation->set_value('fecha_final', trim($colonia->fecha_final)),
			'value'    => $this->form_validation->set_value('fecha_final', formato_fecha($colonia->fecha_final)),
			'class'    => 'form-control',
			'readonly' => 'readonly'
			);


		$this->data['fecha_registro'] = array(
			'type'     => 'text',
			'name'     => 'fecha_registro',
			'id'       => 'fecha_registro',
			//'value'    => $this->form_validation->set_value('fecha_registro', trim($colonia->fecha_registro)),
			'value'    => $this->form_validation->set_value('fecha_registro', formato_fecha($colonia->fecha_registro)),
			'class'    => 'form-control',
			'readonly' => 'readonly'
			);

		$this->data['expediente_hidrico'] = array(
			'name'  => 'expediente_hidrico',
			'id'    => 'expediente_hidrico',
			'type'  => 'text',
			'placeholder'  =>  '9999999/9999',
			'pattern'  => '^[0-9]{1,7}/[0-9]{1,4}$',
			'maxlength' => '12',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('expediente_hidrico', $colonia->expediente_hidrico),
			'readonly' => 'readonly'
		);	
		$this->data['finca'] = array(
			'name'  => 'finca',
			'id'    => 'finca',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('finca', $colonia->finca),

			'readonly' => 'readonly'
		);	

		$this->data['matricula'] = array(
			'name'  => 'matricula',
			'id'    => 'matricula',
			'type'  => 'text',
			'placeholder'  =>  '9999999',
			'pattern'  => '^[0-9]{0,7}$',
			'maxlength' => '7',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('matricula', $colonia->matricula),
			'readonly' => 'readonly'
		);	

		
		$this->data['distrito'] = array(
			'name' => 'distrito',
			'id' => 'distrito',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('distrito', $colonia->distrito),
			'readonly' => 'readonly'
		);
		
		$this->data['localidad'] = array(
			'name' => 'localidad',
			'id' => 'localidad',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('localidad', $colonia->localidad),
			'readonly' => 'readonly'
		);
		
		$this->data['barrio'] = array(
			'name' => 'barrio',
			'id' => 'barrio',
			'type' => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('barrio', $colonia->barrio),
			'readonly' => 'readonly'
		);

		$this->data['actividad'] = array(
			'name'  => 'actividad',
			'id'    => 'actividad',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('actividad', $colonia->actividad),
			'readonly' => 'readonly'
		);
	
		$this->data['id_grupoproyecto'] = array(
			'name'  => 'id_grupoproyecto',
			'id'    => 'id_grupoproyecto',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('id_grupoproyecto', $colonia->id_grupoproyecto),
			'readonly' => 'readonly'
		);

	

	
		$this->data['coor_x'] = array(
			'name'  => 'coor_x',
			'id'    => 'coor_x',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('coor_x', $colonia->coor_x),
			'readonly' => 'readonly'
		);
	
		$this->data['coor_y'] = array(
			'name'  => 'coor_y',
			'id'    => 'coor_y',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('coor_y', $colonia->coor_y),
			'readonly' => 'readonly'
		);
	
		$this->data['col_cod'] = array(
			'name'  => 'col_cod',
			'id'    => 'col_cod',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('col_cod', $colonia->col_cod),
			'readonly' => 'readonly'
		);
	
		$this->data['exp_gestion'] = array(
			'name'  => 'exp_gestion',
			'id'    => 'exp_gestion',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('exp_gestion', $colonia->exp_gestion),
			'readonly' => 'readonly'
		);
	
		$this->data['exp_numero'] = array(
			'name'  => 'exp_numero',
			'id'    => 'exp_numero',
			'type'  => 'text',
			'class' => 'form-control',
			'value' => $this->form_validation->set_value('exp_numero', $colonia->exp_numero),
			'readonly' => 'readonly'
		);


		$a_consultores[''] = 'Seleccione el Consultor';
		$d_consultores = $this->Proyectos_model->dropdown_data('consultores')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_consultores as $r_consultor) {
			$a_consultores[$r_consultor['id_consultor']] = $r_consultor['id_consultor'].' - '.$r_consultor['nombre'].' '.$r_consultor['apellido'];
		}
		$this->data['consultores'] = $a_consultores;
		$this->data['consultores_sel'] = $colonia->id_consultor;

		$a_proponentes[''] = 'Seleccione el Proponente';
		$d_proponentes = $this->Proyectos_model->dropdown_data('proponentes')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_proponentes as $r_proponente) {
			$a_proponentes[$r_proponente['id_proponente']] = $r_proponente['id_proponente'].' - '.$r_proponente['nombre'].' '.$r_proponente['apellido'];
		}
		$this->data['proponentes'] = $a_proponentes;
		$this->data['proponentes_sel'] = $colonia->id_proponente;

		$a_clientes[''] = 'Seleccione el Proponente';
		$d_clientes = $this->Proyectos_model->dropdown_data('cliente')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_clientes as $r_cliente) {
			$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
		}
		$this->data['cliente'] = $a_clientes;
		$this->data['cliente_sel'] = $colonia->id_cliente;

		$a_tipo_estudio[''] = 'Seleccione Tipo de Estudio';
		$d_tipo_estudio = $this->Proyectos_model->concepto('TIPO_ESTUDIO',false,'CONCEPTO')->result_array();
		foreach ($d_tipo_estudio as $r_tipo_estudio) {
			$a_tipo_estudio[$r_tipo_estudio['concepto']] = $r_tipo_estudio['concepto'].' - '.$r_tipo_estudio['nombre'];
		}
		$this->data['tipo_estudio'] = $a_tipo_estudio;
		if (isset($colonia->tipo_estudio)) {
			$this->data['tipo_estudio_sel'] = $colonia->tipo_estudio;
		} else {
			$this->data['tipo_estudio_sel'] = null;  // O cualquier valor por defecto
		}

		$a_tipo_proyecto[''] = 'Seleccione Tipo de Proyecto';
		$d_tipo_proyecto = $this->Proyectos_model->concepto('TIPO_PROYECTO',false,'CONCEPTO')->result_array();
		foreach ($d_tipo_proyecto as $r_tipo_proyecto) {
			$a_tipo_proyecto[$r_tipo_proyecto['concepto']] = $r_tipo_proyecto['nombre'];
		}
		$this->data['tipo_proyecto'] = $a_tipo_proyecto;
		$this->data['tipo_proyecto_sel'] = $colonia->tipo_proyecto;

		// Obtener el grupo de proyectos desde el modelo
		$a_grupo_proyecto[''] = 'Seleccione Grupo Proyecto';
		$d_grupo_proyecto = $this->Proyectos_model->concepto('GRUPO_PROYECTO',false,'CONCEPTO')->result_array();
		foreach ($d_grupo_proyecto as $r_grupo_proyecto) {
			$a_grupo_proyecto[$r_grupo_proyecto['concepto']] = $r_grupo_proyecto['nombre'];
		}
		$this->data['grupo_proyecto'] = $a_grupo_proyecto;
		$this->data['grupo_proyecto_sel'] = isset($colonia->id_grupoproyecto) ? $colonia->id_grupoproyecto : null;  // Valor seleccionado

		// Obtener el sector de proyectos desde el modelo
		$a_sector[''] = 'Seleccione Sector';
		$d_sector = $this->Proyectos_model->concepto('SECTORE_PROYECTOS',false,'CONCEPTO')->result_array();
		foreach ($d_sector as $r_sector) {
			$a_sector[$r_sector['concepto']] = $r_sector['nombre'];
		}
		$this->data['sector'] = $a_sector;
		$this->data['sector_sel'] = isset($colonia->sector_proyecto) ? $colonia->sector_proyecto : null;  // Valor seleccionado

				


		

		

		$a_estado[''] = 'Seleccione Estado';
		$d_estado = $this->Proyectos_model->concepto('PROYECTO_ESTADO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_estado as $r_estado) {
			$a_estado[$r_estado['concepto']] = $r_estado['concepto'].' - '.$r_estado['nombre'];
		}
		$this->data['estado'] = $a_estado;
		$this->data['estado_sel'] = $colonia->estado;

		$a_dpto[''] = 'Seleccione el Departamento';
		$d_dpto = $this->Proyectos_model->dropdown_data('dpto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_dpto as $r_dpto) {
			$a_dpto[$r_dpto['dpto']] = $r_dpto['dpto'].' - '.$r_dpto['dpto_desc'];
		}
		$this->data['dpto'] = $a_dpto;
		$this->data['dpto_sel'] = $colonia->dpto;

		$a_distrito[''] = 'Seleccione el Distrito';
		$d_distrito = $this->Proyectos_model->dropdown_data('distritos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($d_distrito as $r_distrito) {
			$a_distrito[$r_distrito['distrito']] = $r_distrito['distrito'].' - '.$r_distrito['dist_desc'];
		}
		$this->data['distrito'] = $a_distrito;
		$this->data['distrito_sel'] = $colonia->distrito;

		$a_barloc[''] = 'Seleccione el Barrio';
		// Obtener solo los barrios que pertenecen al departamento y distrito seleccionados
		$d_barloc = $this->Proyectos_model->get_barloc_by_distrito($colonia->dpto, $colonia->distrito);

		foreach ($d_barloc as $r_barloc) {
			$a_barloc[$r_barloc->id] = $r_barloc->barlo_desc;
		}

		$this->data['barloc'] = $a_barloc;
		$this->data['barloc_sel'] = $colonia->barrio;

		
		
		
		$this->template->admin_render('man_espacial/proyectos/ver', $this->data);
	}
	public function ver2($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proyectos_ver'), 'proyectos/ver');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$colonia = $this->Proyectos_model->view('proyectos', array('gid' => $gid))->row();
		//$colonia = $this->Proyectos_model->view('proyectos', array('' => ))->row();

		/* Validate form input */
		//$this->form_validation->set_rules('col_cod', $this->lang->line('edit_colonia_validation_name_label'), 'required|is_numeric|max_length[3]');
		
		$this->form_validation->set_rules('nombre', $this->lang->line('edit_colonia_validation_name_label'), 'required');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$dptodistrito = $_POST['dpto_cod_distrito'];
				$dpto = substr($dptodistrito, 0, 2);
				$dist = substr($dptodistrito, 2, 2);

				if ($_POST['dpto_distrito_colonia']) {
					$arraycampos['codigo'] 			= $_POST['dpto_distrito_colonia'];
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']			= strtoupper($_POST['nombre']);
				}

				if ($_POST['proponente']) {
					$arraycampos['proponente']		= $_POST['proponente'];
				}

				if ($_POST['fecha_registro']) {
					$arraycampos['fecha_registro']			= $_POST['fecha_registro'];
				}

				if ($_POST['fecha_registro']) {
					$arraycampos['fecha_registro']			= $_POST['fecha_registro'];
				}

				if ($_POST['descripcion']) {
					$arraycampos['descripcion']		= trim($_POST['descripcion']);
				}

				if ($_POST['fecha_registro']) {
					$arraycampos['fecha_registro']	= $_POST['fecha_registro'];
				}

				$colonia_update = $this->Proyectos_model->update_colonia($gid,$arraycampos);

				if ($colonia_update)
				{

					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_colonia_saved') por $_POST('id') por ejemplo
					$this->session->set_flashdata('message', $this->lang->line('colonia_update_successful'));
					redirect('man_espacial/proyectos/proyectos/ver/'.$gid); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/proyectos/proyectos', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['colonia']   = $colonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->nombre ? 'readonly' : '';
		
		//creando campos
			//$this->data['dpto'] = $colonia->dpto_cod;
			//$this->data['dist'] = $colonia->dist_cod;
			//$this->data['colonia'] = $colonia->col_cod;
			$this->data['gid'] = $colonia->col_cod;



			$this->data['col_cod'] = array(
				'type'     => 'text',
				'name'     => 'col_cod',
				'id'       => 'col_cod',
				'value'    => $this->form_validation->set_value('colonia_col_cod', $colonia->col_cod),
				'data-src' => $colonia->col_cod,
				'class'    => 'form-control',
				'disabled'    => true
			);
		 
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('colonia_nombre', $colonia->nombre),
				'data-src' => $colonia->nombre,
				'class'    => 'form-control',
				'disabled'    => true
			);

			$this->data['id_proponente'] = array(
				'name'  => 'id_proponente',
				'id'    => 'id_proponente',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_id_proponente', $colonia->id_proponente),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['fecha_registro'] = array(
				'name'  => 'fecha_registro',
				'id'    => 'fecha_registro',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_fecha_registro', $colonia->fecha_registro),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['descripcion'] = array(
				'type'  => 'text',
				'name'  => 'descripcion',
				'id'    => 'descripcion',
				'style' => 'width: 268px;height: 150px',
				'value'    => $this->form_validation->set_value('colonia_descripcion', $colonia->descripcion),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['fecha_registro'] = array(
				'name'  => 'fecha_registro',
				'id'    => 'fecha_registro',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_nombre', $colonia->fecha_registro),
				'class' => 'form-control',
				'disabled'    => true
			);


/*
		$dptos[''] = 'Dpto. Distrito y Colonia';
		//$dpto_distrito = $this->Proyectos_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		/
		$dpto_distrito = $this->Proyectos_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dpto_distrito as $dd) {
			$dpto_distritos[$dd['dpto'].$dd['distrito']] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'];
		}
		$this->data['dpto_distrito'] = $dpto_distritos;
		$this->data['dpto_distrito_sel'] = $colonia->dpto_cod.$colonia->dist_cod;
*/
/*
		$dptodistritoproyectos[''] = 'Dpto. Distrito y Colonia';
		//$dptodistritocolonia = $this->Proyectos_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		$dptodistritocolonia = $this->Proyectos_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dptodistritocolonia as $dd) {
			$col_cod = str_pad($dd['col_cod'], 3, "0", STR_PAD_LEFT);
			$dptodistritoproyectos[$dd['dpto'].$dd['distrito'].$col_cod] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'].' - Colonia.:('.$col_cod.') '.$dd['nombre'];
		}
		$this->data['dpto_distrito_colonia'] = $dptodistritoproyectos;
		$this->data['dpto_distrito_colonia_sel'] = $colonia->codigo;
		//$this->data['dpto_distrito_colonia_sel'] = $colonia->dpto_cod.$colonia->dist_cod.str_pad($colonia->col_cod, 3, "0", STR_PAD_LEFT);
*/
		$dptos[''] = 'Seleccione el departamento';
		$departamentos = $this->Proyectos_model->dropdown_data('departamentos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($departamentos as $dpto) {
			$dptos[$dpto['dpto']] = $dpto['dpto'].' - '.$dpto['dpto_desc'];
		}
		$this->data['departamentos']     = $dptos;
		//$this->data['departamentos_sel'] = $colonia->dpto_cod;

		/* Load Template */
		$this->template->admin_render('man_espacial/proyectos/ver', $this->data);
	}

	/**
	 * 
	 * setExcel
	 */
	public function setExcel () 
	{
	     
	    // configuramos las propiedades del documento
	    $this->phpexcel->getProperties()
					->setCreator("Arkos Noem Arenom")
					->setLastModifiedBy("Arkos Noem Arenom")
					->setTitle("Office 2007 XLSX Test Document")
					->setSubject("Office 2007 XLSX Test Document")
					->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
					->setKeywords("office 2007 openxml php")
					->setCategory("Test result file");
	     
	     
	    // agregamos información a las celdas
	    $this->phpexcel->setActiveSheetIndex(0)
	                ->setCellValue('A5', 'N°')
	                ->setCellValue('B5', 'N° DE TITULO')
	                ->setCellValue('C5', 'MANZANA INDERT')
	                ->setCellValue('D5', 'MANZANA INDERT')
	                ->setCellValue('E5', 'LOTE INDERT')
	                ->setCellValue('F5', 'LOTE SIRT')
	                ->setCellValue('G5', 'NOMBRE DEL BENEFICIARIO')
	                ->setCellValue('H5', 'N° DE C.I. DEL BENEFICIARIO')
	                ->setCellValue('I5', 'NOMBRE DEL OCUPANTE ACTUAL')
	                ->setCellValue('J5', 'N° DE C.I. DEL OCUPANTE ACTUAL')
	                ->setCellValue('K5', 'SUPERFICIE (HAS)')
	                ->setCellValue('L5', 'SITUACION CON RESPECTO AL LOTE')
	                ->setCellValue('M5', 'HACE CUANTO OCUPA EL LOTE')
	                ->setCellValue('N5', 'CONDICION DE LA VIVIENDA')
	                ->setCellValue('O5', 'EXPEDIENTE N°')
	                ->setCellValue('P5', 'AÑO')
	                ->setCellValue('Q5', 'NOMBRE DEL SOLICITANTE SEGÚN EXPEDIENTE')
	                ->setCellValue('R5', 'OTROS DOCUMENTOS')
	                ->setCellValue('S5', 'OBSERVACIONES');

	    $styleArray = array(
							'borders' => array('allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN,
																  'color' => array('argb' => '343b36'),
																  ),
											   ),
							);
		$this->phpexcel->getActiveSheet()->getStyle('A5:S5')->applyFromArray($styleArray);
		$this->phpexcel->getActiveSheet()->getStyle('A5:S5')->getAlignment()->setWrapText(true);	                
	    $this->phpexcel->getActiveSheet()->getStyle('A5:S5')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('d2d2d2');
	     
	    // La librería puede manejar la codificación de caracteres UTF-8
	    for ($i=0; $i < 5; $i++) { 
	    	if ($i > 1) {
	    		$this->phpexcel->setActiveSheetIndex(0)
	                ->setCellValue('A'.$i, 'A')
	                ->setCellValue('B'.$i, 'B')->getStyle('A8')->getAlignment()->setWrapText(true);;
	    	}
	        
	    }
	    //$this->phpexcel->setActiveSheetIndex(0)
	     //           ->setCellValue('A4', 'Miscellaneous glyphs')
	     //           ->setCellValue('A5', 'éàèùâêîôûëïüÿäöüç');
	     
	    // Renombramos la hoja de trabajo
	    $this->phpexcel->getActiveSheet()->setTitle('Simple');
	     
	     
	    // configuramos el documento para que la hoja
	    // de trabajo número 0 sera la primera en mostrarse
	    // al abrir el documento
	    $this->phpexcel->setActiveSheetIndex(0);
	     
	     
	    // redireccionamos la salida al navegador del cliente (Excel2007)
	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment;filename="01simple.xlsx"');
	    header('Cache-Control: max-age=0');
	     
	    $objWriter = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
	    $objWriter->save('php://output');
	     
	}
	// end: setExcel	



	public function trae_distritos()
	{
		//$dpto 	   = $_POST['dpto_cod'];
		$_GET = array_merge($_GET,$_POST);
  		$dpto = $_GET["dpto_cod"];

		$distritos = $this->Proyectos_model->dropdown_data('distritos',array('dpto' => $dpto), 'distrito')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->distrito . '">' . $value->distrito . ' - ' . $value->dist_desc . '</option>';
		}

		//echo json_encode($distritos);
	}


	/**
	 * generar_excel_pericia_resum
	 *	Genera un documento excel a partir de los datos obtenidos de la pericias de las parcelas
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function obtener_parcelas_sinpericias ($dpto, $distrito, $colonia) {
		
		//$dpto=$_POST['dpto'];
		//$distrito=$_POST['distrito'];
		//$colonia=$_POST['colonia'];
		$resultado = $this->Proyectos_model->eliminar_basura();
		$parcelas['data'] = $this->Proyectos_model->obtener_parcelas_sinpericias($dpto, $distrito, $colonia)->result_array();
		$parcelas['cantidad'] = $this->Proyectos_model->contador_registros('v_pericias_lados', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		$parcelas['cantper'] = $this->Proyectos_model->contador_registros('in_planopericia1', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}


	/**
	 * obtener_parcelas ($dpto, $distrito, $colonia)
	 * Obtiene las parcelas de in_temp que su pericia no haya sido generada o 
	 * que su pericia sea incongruete con la geometria actual para que sean
	 * obligatoriamente sean nuevamente generadas.
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function obtener_parcelas ($dpto, $distrito, $colonia) {
		
		//$dpto=$_POST['dpto'];
		//$distrito=$_POST['distrito'];
		//$colonia=$_POST['colonia'];
		$parcelas['data'] = $this->Proyectos_model->obtener_parcelas('v_in_temp_gp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result_array();
		$parcelas['cantidad'] = $this->Proyectos_model->contador_registros('v_in_temp_gp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		$parcelas['cantper'] = $this->Proyectos_model->contador_registros('v_in_planopericia1_cnt', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}




	/**
	 * contar_pericia_completa()
	 * contar_pericia_completa()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function contar_pericia_completa () {
		
		$dpto=$_POST['dpto'];
		$distrito=$_POST['distrito'];
		$colonia=$_POST['colonia'];
		$parcelas['cantidad'] = $this->Proyectos_model->contador_registros('in_temp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}


	/**
	 * generar_pericia_completa()
	  *generar_pericia_completa()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function generar_pericia_completa ($dpto, $distrito, $colonia, $gid) {
		$resultado=$this->Proyectos_model->md_generar_pericia_completa($dpto, $distrito, $colonia);
		if ($resultado) {
			$this->session->set_flashdata('message', 'Pericia generada correctamente!');
			redirect('man_espacial/proyectos/proyectos/ver/'.$gid);
		}		
		else {
			$this->session->set_flashdata('message', 'Pericia NO generada!');
		}	
	}


	/**
	 * generar_pericia_completa_1_a_1()
	 * generar_pericia_completa_1_a_1()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function generar_pericia_completa_1_a_1 ($dpto, $distrito, $colonia, $gid) {
		$i = 0;
		$parcelas = $this->Proyectos_model->view('in_temp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result();
		foreach ($parcelas as $prc) {
			$i=$i+1;
			$this->Proyectos_model->generar_pericia($prc->objectid);
			//echo $prc->objectid;
			//$this->session->set_flashdata('message', 'Genero la parcela '.$prc->objectid);
		}
		if ($i == 0) {			
			$this->session->set_flashdata('message', 'La generacion de Pericias NO SE REALIZO!');			
		}
		else {
			$this->session->set_flashdata('message', 'La generacion de pericias se REALIZO! <b>');
			redirect('man_espacial/proyectos/proyectos/ver/'.$gid);		
		}	
	}


	/**
	* generar_colonia_lineas()
	* generar_colonia_lineas()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_colonia_lineas()
	{	

		// Si se usa mas de una vez el $_POST es necesario asignar sus valores a variables
		$tabla = $_POST['tabla']; 
        $dpto = $_POST['dpto'];
        $distrito = $_POST['distrito'];
        $colonia = $_POST['colonia'];
        
		$existe_colonia = $this->Proyectos_model->contador_registros($tabla, array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));

		if ($existe_colonia == 0) {
			echo 'NO';
		}else{
			$resultado = $this->Proyectos_model->md_generar_lineas($dpto, $distrito, $colonia);
			if ($resultado == TRUE) {
				echo 'SI';
			}else{
				echo 'NO';
			}											
		}
	}


	/**
	* existe_colonia()
	* existe_colonia()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function existe_colonia()
	{
		$existe_colonia = $this->Proyectos_model->contador_registros($_POST['tabla'], array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
		
		if ($existe_colonia > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	/**
	* generar_periciasimple ($objectid) 
	* generar_periciasimple ($objectid) 
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_periciasimple ($objectid) {
		
		//$objectid	= $_POST['objectid'];
		$pericia = $this->Proyectos_model->generar_periciasimple($objectid);
		if ($pericia == TRUE) {
			return true;
		}else{
			return false;
		}
	}

	/**
	* generar_periciaresumido ($objectid)
	* generar_periciaresumido ($objectid)
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_periciaresumido ($objectid) {
		
		//$objectid	= $_POST['objectid'];
		$pericia = $this->Proyectos_model->generar_periciaresumido($objectid);
		if ($pericia == TRUE) {
			return true;
		}else{
			return false;
		}
	}

	/**
	* eliminar_parcelas()
	* eliminar_parcelas()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function eliminar_parcelas()
	{	
		$existen_parcelas = $this->Proyectos_model->contador_registros('in_temp',array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
		
		if ($existen_parcelas == 0) {
			echo 'SI';
		}else{
			$eliminar_parcelas = $this->Proyectos_model->eliminar_parcelas('in_temp',array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
			echo 'BORRADA';
		}
	}


	/**
	* eliminar_pericia($objectid)
	* eliminar_pericia($objectid)
	* @return bool
	* @author Jaime Rojas 
	**/
	public function eliminar_pericia($objectid)
	{	

		$resultado = $this->Proyectos_model->eliminar_pericia($objectid);
		if ($resultado == TRUE) {
			return true;
		}else{
			return false;
		}
	}


	//////----------------------------------------//////
	//////                 delete()               //////
	//////----------------------------------------//////
	public function delete($gid)
	{

		$cnt_reg = $this->Proyectos_model->cnt_col_reg_layers($gid);

		if ($cnt_reg == 0) {

			$eliminar_colonia = $this->Proyectos_model->eliminar_colonia($gid);
			$this->session->set_flashdata('message', 'Se elimino el proyecto! <b>');
			redirect('man_espacial/proyectos/proyectos/index/');

		}else{

			$this->session->set_flashdata('message', 'NO se pude eliminar porque tiene registros dependientes! <b>');
			redirect('man_espacial/proyectos/proyectos/index/');

		}

	}


	public function vercolonia ($gid) {

	/*
	        echo '<pre>';
	        print_r( $gid );
	        echo '</pre>';
	        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/sirtvisor/index.html?tipo_consulta=colonia_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);	
			redirect($i_jameuge);
	}

	// Nuevo 02/09/2025

	public function export_excel() 
	{
		$proyectos = $this->Proyectos_model->get_proyectos1();
	
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
	
		// Título principal
		$sheet->setCellValue('A1', 'Proyectos de Impacto Ambiental');
		$sheet->mergeCells('A1:J1'); // Unir celdas para el título
		$sheet->getStyle('A1')->getFont()->setBold(true)->setSize(24);
		$sheet->getStyle('A1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
	
		// Encabezados de la tabla
		$headers = [
			'A2' => 'ID', 'B2' => 'Nombre', 'C2' => 'Descripción', 'D2' => 'Proponente',
			'E2' => 'Consultor', 'F2' => 'Código', 'G2' => 'Fecha Registro', 'H2' => 'Fecha Inicio',
			'I2' => 'Fecha Final', 'J2' => 'Estado'
		];
	
		foreach ($headers as $cell => $text) {
			$sheet->setCellValue($cell, $text);
			$sheet->getStyle($cell)->getFont()->setBold(true)->setSize(12);
			$sheet->getStyle($cell)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle($cell)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFC000'); // Fondo amarillo para los encabezados
		}
	
		// Llenar datos
		$row = 3;
		foreach ($proyectos as $p) {
			$sheet->setCellValue('A' . $row, $p['gid']);
			$sheet->setCellValue('B' . $row, $p['nombre']);
			$sheet->setCellValue('C' . $row, $p['descripcion']);
			$sheet->setCellValue('D' . $row, $p['proponente']);
			$sheet->setCellValue('E' . $row, $p['consultor']);
			$sheet->setCellValue('F' . $row, $p['codigo']);
			$sheet->setCellValue('G' . $row, $p['fecha_registro']);
			$sheet->setCellValue('H' . $row, $p['fecha_inicio']);
			$sheet->setCellValue('I' . $row, $p['fecha_final']);
			$sheet->setCellValue('J' . $row, $p['estado']);
			$row++;
		}
	
		// Aplicar bordes a toda la tabla
		$styleArray = [
			'borders' => [
				'allBorders' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					'color' => ['argb' => '000000'],
				],
			],
		];
		$sheet->getStyle('A2:J' . ($row - 1))->applyFromArray($styleArray);
	
		// Ajustar tamaño de columnas automáticamente
		foreach (range('A', 'J') as $col) {
			$sheet->getColumnDimension($col)->setAutoSize(true);
		}
	
		// Establecer formato de descarga
		$filename = 'Proyectos_' . date('Ymd_His') . '.xlsx';
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="' . $filename . '"');
		header('Cache-Control: max-age=0');
	
		$writer = new Xlsx($spreadsheet);
		$writer->save('php://output');
		exit;
	}
	
	
////// Edit 2

public function edit2($gid)
	{
		if (!$this->ion_auth->logged_in() OR !$this->ion_auth->is_admin() OR !$gid OR empty($gid)) {
			redirect('auth', 'refresh');
		}
		$_SESSION['identificador'] = $gid;
		
		$this->breadcrumbs->unshift(2, lang('menu_proyectos_edit'), 'proyectos/edit2');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		
		$colonia = $this->Proyectos_model->view('proyectos', ['gid' => $gid])->row();
		$this->data['documentos'] = $this->Tumba_model->get_documents_by_project($gid, '1');
		
		if (isset($_POST['importar']) && !empty($_FILES['importar_documentos']['name'][0])) {
			$upload_path = "C:/dir_ema/archivos/proyectos/{$gid}/";
			if (!is_dir($upload_path)) mkdir($upload_path, 0777, true);
			$upload_result = $this->Tumba_model->upload_documents('importar_documentos', $upload_path, $gid, '1');
			$this->session->set_flashdata(
				$upload_result['status'] ? 'message' : 'error', 
				$upload_result['status'] ? 'Documentos importados correctamente.' : implode('<br>', $upload_result['errors'])
			);
			redirect(current_url());
		}
		
		// Definir reglas de validación para cada campo
		$fields = [
			'mesa_control'        => 'max_length[50]', 
			'mesa_fecha_ini'      => 'date', 
			'mesa_fecha_pago'     => 'date', 
			'mesa_obs'            => '',
			'mesa_usu_modif'      => 'max_length[50]', 
			'atec_ini'            => 'max_length[2]', 
			'atec_ini_fecha'      => 'date', 
			'atec_ini_obs'        => '',
			'atec_ini_usu_modif'  => 'max_length[50]', 
			'geomatica'           => 'max_length[50]', 
			'geo_fecha_ini'       => 'date', 
			'geo_obs'             => '',
			'geo_usu_modif'       => 'max_length[50]', 
			'atecnico'           => 'max_length[50]', 
			'atec_fecha_ini'      => 'date', 
			'atec_fecha_fin'      => 'date',
			'atec_obs'            => '', 
			'direc_mades'         => 'max_length[50]', 
			'atec_usu_modif'      => 'max_length[50]', 
			'rima_p'              => 'max_length[50]',
			'rima_p_fecha'        => 'date', 
			'rima_p_obs'          => '', 
			'rima_p_usu_modif'    => 'max_length[50]', 
			'rima_w'              => 'max_length[50]',
			'rima_w_fecha'        => 'date', 
			'rima_w_obs'          => '', 
			'rima_w_usu_modifi'   => 'max_length[50]', 
			'diva'                => 'max_length[50]',
			'diva_fecha_ini'      => 'date', 
			'diva_obs'            => '', 
			'diva_usu_modif'      => 'max_length[50]', 
			'dir_gen'             => 'max_length[50]',
			'dir_gen_fecha_ini'   => 'date', 
			'dir_gen_obs'         => '', 
			'dir_gen_usu_modif'   => 'max_length[50]'
		];
		
		// Asignar mensaje de error para la regla date si no está definido en el archivo de idioma
		$this->form_validation->set_message('date', 'El campo %s debe contener una fecha válida.');
		
		foreach ($fields as $field => $rule) {
			$this->form_validation->set_rules($field, ucfirst(str_replace('_', ' ', $field)), $rule);
		}
		
		if ($_POST && !empty($_POST)) {
			if ($this->form_validation->run()) {
				$arraycampos = [];
		
				// Definir campos que tienen fechas asociadas
				$campo_fechas = [
					'mesa_control' => ['mesa_fecha_ini', 'mesa_fecha_pago'],
					'atec_ini'     => ['atec_ini_fecha'],
					'geomatica'    => ['geo_fecha_ini'],
					'atecnico'     => ['atec_fecha_ini', 'atec_fecha_fin'],
					'rima_p'       => ['rima_p_fecha'],
					'rima_w'       => ['rima_w_fecha'],
					'diva'         => ['diva_fecha_ini'],
					'dir_gen'      => ['dir_gen_fecha_ini'],
				];
		
				// Procesar los datos enviados en el formulario
				foreach ($fields as $key => $rule) {
					if (isset($_POST[$key]) && trim($_POST[$key]) !== '') {
						if (array_key_exists($key, $campo_fechas)) {
							$arraycampos[$key] = $_POST[$key];

							// Si el campo principal es "NO", establecer sus fechas relacionadas en NULL
							if ($_POST[$key] === 'NO') {
								foreach ($campo_fechas[$key] as $fecha_campo) {
									$arraycampos[$fecha_campo] = null;
								}
							}
						} else {
							// Convertir el valor a mayúsculas si no es un campo de fechas relacionadas
							$arraycampos[$key] = strtoupper($_POST[$key]);
						}
					} else {
						// Si el campo principal está vacío, asignar "NO" y limpiar las fechas relacionadas
						if (array_key_exists($key, $campo_fechas)) {
							$arraycampos[$key] = 'NO';
							foreach ($campo_fechas[$key] as $fecha_campo) {
								$arraycampos[$fecha_campo] = null;
							}
						}
					}
				}
		
				$colonia_update = $this->Proyectos_model->update_colonia($gid, $arraycampos);

				if ($colonia_update) {
					// Si la actualización fue exitosa
					$this->session->set_flashdata('message', '✅ El proyecto ha sido actualizado correctamente.');
					redirect('man_espacial/proyectos/proyectos/edit2/' . $gid);
				} else {
					// Si no hubo cambios en la actualización
					$this->session->set_flashdata('message', '⚠ No se realizaron cambios en el proyecto.');
					redirect('man_espacial/proyectos/proyectos/edit2/' . $gid);
				}
			} else {
				// Si la validación de formulario falla
				$this->session->set_flashdata('message', '❌ Error en la validación del formulario. Revisa los campos.');
				redirect('man_espacial/proyectos/proyectos/edit2/' . $gid);
			}
		}

		
		$proyecto_a = $this->Proyectos_model->view('proyectos', ['gid' => $gid])->row();
		foreach ($proyecto_a as $key => $value) {
			$arraycampos[$key] = $value;
		}
		$_SESSION['arraycampos'] = $arraycampos;
		
		$decode_ema_a = $this->Proyectos_model->view('v_proyectos_index', ['gid' => $gid])->row();
		$decode_ema = [
			'nombre_decode'     => $decode_ema_a->nombre_decode,
			'consultor_decode'  => $decode_ema_a->consultor_decode,
			'proponente_decode' => $decode_ema_a->proponente_decode,
		];
		$_SESSION['decode_ema'] = $decode_ema;
		
		$this->data['message'] = validation_errors() ?: ($this->ion_auth->errors() ?: $this->session->flashdata('message'));
		$this->data['colonia'] = $colonia;
		
		foreach ($fields as $key => $rule) {
			$value = isset($arraycampos[$key]) ? $arraycampos[$key] : '';
		
			// Si es un campo de fecha y tiene un valor, reformatearlo a dd/mm/yyyy
			if (strpos($key, 'fecha') !== false && !empty($value)) {
				$date = DateTime::createFromFormat('Y-m-d', $value);
				$value = $date ? $date->format('d/m/Y') : $value;
			}
		
			$this->data[$key] = [
				'type'  => 'text',
				'name'  => $key,
				'id'    => $key,
				'value' => $this->form_validation->set_value($key, $value),
				'class' => 'form-control'
			];
		}
		
		$this->template->admin_render('man_espacial/proyectos/edit2', $this->data);
	}
		
}