<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('expedientes/expedientes_model');
		$this->lang->load('expedientes/expedientes_lang');
		$this->load->helper('download');
		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_expedientes'));
		$this->data['pagetitle'] = $this->page_title->show();


		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'EXPEDIENTES') {

			$_SESSION['arraywhere_expedientes'] 		 = NULL;
			$_SESSION['arraywhere_expedientes_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'EXPEDIENTES';
		}   
		
		/* Breadcrumbs :: Common */

		$this->breadcrumbs->unshift(1, lang('menu_expedientes'), 'expedientes/expedientes');
	}

	public function expe_mantenimiento($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'expedientes/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->expedientes_model->view('exp', array('expe_id' => $expe_id))->row();

	        $expe_id_expediente = $exp_datos->expe_id_expediente;
	        $expe_gestion		= $exp_datos->expe_gestion;

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
	        

			$expe_info  = $this->expedientes_model->view('exp', array('expe_id' => $expe_id))->result_array();
			

			$expe_info[0]["expe_tipo_ref_desc"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]));

			$expe_info[0]["expe_estado_desc"]='';


			/*--------------- CANTIDAD DATOS GRAFICOS --------------------*/


			$datos_graficos[0]['uso86']		      = $this->expedientes_model->contador_registros_all('uso86'); 		
			$datos_graficos[0]['uso_actual']	  = $this->expedientes_model->contador_registros_all('uso_actual'); 		
			$datos_graficos[0]['uso_alternativo'] = $this->expedientes_model->contador_registros_all('uso_alternativo');
			$datos_graficos[0]['fincas']		  = $this->expedientes_model->contador_registros_all('fincas'); 			
			$datos_graficos[0]['parcelas']		  = $this->expedientes_model->contador_registros_all('parcelas'); 	
			$datos_graficos[0]['capacidad']		  = $this->expedientes_model->contador_registros_all('capacidad'); 	
			$datos_graficos[0]['taxonomia']		  = $this->expedientes_model->contador_registros_all('taxonomia'); 	
				

			/*---------------- FIN CANTIDAD DATOS GRAFICOS ---------------*/

			$this->data['expe_info'] 		= $expe_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['expe_id_expediente'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id_expediente',
				'id'       => 'expe_id_expediente',
				'value'    => $expe_id_expediente
			);

			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_gestion',
				'id'       => 'expe_gestion',
				'value'    => $expe_gestion
			);

			$this->data['expe_id'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id',
				'id'       => 'expe_id',
				'value'    => $expe_id
			);

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('expedientes/Mantenimiento', $this->data);
		}
	}


	public function mantenimiento_colmen($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'expedientes/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->expedientes_model->view('exp', array('expe_id' => $expe_id))->row();

	        $expe_id_expediente = $exp_datos->expe_id_expediente;
	        $expe_gestion		= $exp_datos->expe_gestion;

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
	        

			$expe_info  = $this->expedientes_model->view('exp', array('expe_id' => $expe_id))->result_array();
			

			$expe_info[0]["expe_tipo_ref_desc"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]));

			$expe_info[0]["expe_estado_desc"]='';


			/*--------------- CANTIDAD DATOS GRAFICOS --------------------*/


			$datos_graficos[0]['uso86']		      = $this->expedientes_model->contador_registros_all('uso86'); 		
			$datos_graficos[0]['uso_actual']	  = $this->expedientes_model->contador_registros_all('uso_actual'); 		
			$datos_graficos[0]['uso_alternativo'] = $this->expedientes_model->contador_registros_all('uso_alternativo');
			$datos_graficos[0]['fincas']		  = $this->expedientes_model->contador_registros_all('fincas'); 			
			$datos_graficos[0]['parcelas']		  = $this->expedientes_model->contador_registros_all('parcelas'); 	
			$datos_graficos[0]['capacidad']		  = $this->expedientes_model->contador_registros_all('capacidad'); 	
			$datos_graficos[0]['taxonomia']		  = $this->expedientes_model->contador_registros_all('taxonomia'); 	
				

			/*---------------- FIN CANTIDAD DATOS GRAFICOS ---------------*/

			$this->data['expe_info'] 		= $expe_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['expe_id_expediente'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id_expediente',
				'id'       => 'expe_id_expediente',
				'value'    => $expe_id_expediente
			);

			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_gestion',
				'id'       => 'expe_gestion',
				'value'    => $expe_gestion
			);

			$this->data['expe_id'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id',
				'id'       => 'expe_id',
				'value'    => $expe_id
			);

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('expedientes/Mantenimiento', $this->data);
		}
	}


	public function eliminar_datos_tabla($tabla = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

		

		$resultado = $this->expedientes_model->eliminar_datos_tabla($tabla);

		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$expe_id);
		
	}

	public function eliminar_geometrias($exp = NULL, $gest = NULL, $expe_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

		

		$resultado = $this->expedientes_model->eliminar_geometrias($exp,$gest,$expe_id);

		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$expe_id);
		
	}


	public function download_expe($expe_id = NULL)
	{
	
        //exec('cmd /c "C:\dir_ema\bya_exp_tablas_a_shp.bat postgres Elefante2024i7 '.trim($expe_id).'"');	

        exec('/dir_ema/bya_exp_tablas_a_shp.sh postgres Elefante2025i7 '.trim($expe_id));	

        $download_file = "expe".$expe_id.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$expe_id);

	}


	public function importar_shapes()
	{
		$id_expediente 	= $_POST['expe_id_expediente'];
		$gestion 		= $_POST['expe_gestion'];
		$expe_id 		= $_POST['expe_id'];
		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}
		/*
        uso86     
        uso_actual
		uso_alternativo
        fincas
        parcelas
        capacidad 
        taxonomia
        */
		if ($accion == 20){
			$resultado = $this->expedientes_model->eliminar_datos_tabla('uso86');
			$TABLA ='uso86';
		}else{
			if ($accion == 21){
				$resultado = $this->expedientes_model->eliminar_datos_tabla('uso_actual');	
				$TABLA ='uso_actual';			
			}else{
				if ($accion == 22){
					$resultado = $this->expedientes_model->eliminar_datos_tabla('uso_alternativo');		
					$TABLA ='uso_alternativo';	
				}else{
					if ($accion == 23){
						$resultado = $this->expedientes_model->eliminar_datos_tabla('fincas');	
						$TABLA ='fincas';
					}else{
						if ($accion == 24){
							$resultado = $this->expedientes_model->eliminar_datos_tabla('parcelas');	
							$TABLA ='parcelas';
						}else{
							if ($accion == 25){
								$resultado = $this->expedientes_model->eliminar_datos_tabla('capacidad');
								$TABLA ='capacidad';	
							}else{								
								if ($accion == 26){
									$resultado = $this->expedientes_model->eliminar_datos_tabla('taxonomia');
									$TABLA ='taxonomia';
								}												
							}																			
						}												
					}												
				}							
			}			
		}

		if ( $accion >= 20) {
			$this->session->set_flashdata('message', '¡SE ELIMINO DATOS DE LA TABLA!'.$TABLA);
			redirect('expedientes/mantenimiento/expe_mantenimiento/1');
		}

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/1');
		}		

		$expe_id=1;
         
 		$resultado=0;
		if ($accion == 10){
			$resultado = $this->expedientes_model->contador_registros_all('uso86');
			$TABLA ='uso86';
		}else{
			if ($accion == 11){
				$resultado = $this->expedientes_model->contador_registros_all('uso_actual');				
				$TABLA ='uso_actual';
			}else{
				if ($accion == 12){
					$resultado = $this->expedientes_model->contador_registros_all('uso_alternativo');		
					$TABLA ='uso_alternativo';
				}else{
					if ($accion == 13){
						$resultado = $this->expedientes_model->contador_registros_all('fincas');	
						$TABLA ='fincas';
					}else{
						if ($accion == 14){
							$resultado = $this->expedientes_model->contador_registros_all('parcelas');	
							$TABLA ='parcelas';
						}else{
							if ($accion == 15){
								$resultado = $this->expedientes_model->contador_registros_all('capacidad');	
								$TABLA ='capacidad';
							}else{								
								if ($accion == 16){
									$resultado = $this->expedientes_model->contador_registros_all('taxonomia');
									$TABLA ='taxonomia';
								}												
							}																			
						}												
					}												
				}							
			}			
		}

		$expe_id=1;

		if ($resultado > 0) {
			$this->session->set_flashdata('message', 'LA TABLA '.$TABLA.' TIENE DATOS!');
			//echo($TABLA);
			//show_error(1);
			redirect('expedientes/mantenimiento/expe_mantenimiento/1');
		}
		else { 		
			$expe_id=1;

			exec('cmd /c "'.trim('md C:\dir_ema\ ').trim($expe_id).'"');		
			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');
			$ruta_dest = trim('C:\dir_ema\ ').trim($expe_id).trim('\ ');

			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;		
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);
						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;
					
					default:
						$i = $i + 1;
						break;			
				}
			}							
			//echo 'TABLA: '.$TABLA;
			//show_error('TEMPORALMENTE INACTIVO');
			exec('cmd /c "C:\dir_ema\bya_imp_shp_a_tabla.bat '.trim($TABLA).'"');				

			$actu = $this->expedientes_model->copiar_temporal_a_bya($TABLA)->row()->copiar_temporal_a_bya;
			if ($actu>0) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('expedientes/mantenimiento/expe_mantenimiento/1');
			}
			else { 	
				$this->session->set_flashdata('message', '¡IMPORTADOS!');		
				redirect('expedientes/mantenimiento/expe_mantenimiento/1');
			}
		}
	}

	public function veri3geo () {
	
        	$i_jameuge = "http://217.77.14.121:8061/i3geo/ms_criamapa.php";

			redirect($i_jameuge);
	}


}