<?php

    /**
     * Prouectos MOPC
     *
     * @return bool
     * @author Diego Ferreira Escobar
     **/


defined('BASEPATH') OR exit('No direct script access allowed');

class Conceptos extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('conceptos/conceptos_model');
        $this->lang->load('conceptos/conceptos');

        /* Title Page :: Common */
        $this->page_title->push(lang('menu_conceptos'));
        $this->data['pagetitle'] = $this->page_title->show();
        
        $_SESSION['id_modulo'] = 'CONCEPTOS';


        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_conceptos'), 'conceptos/conceptos');
    }
    
    
	public function index()
	{

       if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Llama al modelo de la vista */
            $this->data['conceptos'] = $this->conceptos_model->conceptos()->result();

            /* Load Template */
            $this->template->admin_render('conceptos/index', $this->data);
        }
    }


    public function create()
    {

        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_conceptos'), 'conceptos/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Valida cada campo del formulario crear */
        /* Validación form input */
        $this->form_validation->set_rules('concepto', 'lang:create_concepto_validation_name_label', 'required');
        $this->form_validation->set_rules('nombre', 'lang:create_nombre_validation_name_label', 'required');
        $this->form_validation->set_rules('tipoconcepto', 'lang:create_tipoconcepto_validation_name_label', 'required');
        //$this->form_validation->set_rules('clase', 'lang:create_clase_validation_name_label','required|is_numeric|min_length[1]|max_length[1]');

        /* Validación form input */
       // $this->form_validation->set_rules('url', 'lang:create_url_validation_name_label', 'required');

              
        if ($this->form_validation->run() == TRUE)
        {
            /* Pasa los datos por post */
            if ($_POST['concepto']) {
                $data['concepto']     = $_POST['concepto'];
            }

            if ($_POST['nombre']) {
                $data['nombre']       = $_POST['nombre'];
            }

            if ($_POST['tipoconcepto']) {
                $data['tipoconcepto'] = $_POST['tipoconcepto'];
            }

            if ($_POST['clase']) {
                $data['clase']        = $_POST['clase'];
            }

            $new_concepto_id             = $this->conceptos_model->create_concepto($data);

            if ($new_concepto_id)
            {
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                redirect('conceptos/conceptos', 'refresh');
            }else{
                $this->session->set_flashdata('message', $this->ion_auth->errors());

                redirect('conceptos/conceptos');

            }
            
        }
        else
        {
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
    
            $this->data['concepto'] = array(
                'name'  => 'concepto',
                'id'    => 'concepto',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('concepto'),
                'maxlength' => 25
            );
            $this->data['nombre'] = array(
                'name'  => 'nombre',
                'id'    => 'nombre',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('nombre'),
                'maxlength' => 100
            );
            $this->data['tipoconcepto'] = array(
                'name'  => 'tipoconcepto',
                'id'    => 'tipoconcepto',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('tipoconcepto'),
                'maxlength' => 100
            );
            $this->data['clase'] = array(
                'name'  => 'clase',
                'id'    => 'clase',
                'type'  => 'number',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('clase'),
                'max'   => 9
            );  

            /* Load Template */
            $this->template->admin_render('conceptos/create', $this->data);
        }
    }

    public function edit($id)
    {
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_conceptos_edit'), 'conceptos/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */
        $conceptos  = $this->conceptos_model->concepto($id)->row();

         /* Validación form input */
        $this->form_validation->set_rules('concepto', 'lang:create_concepto_validation_name_label', 'required');
        $this->form_validation->set_rules('nombre', 'lang:create_nombre_validation_name_label', 'required');
        $this->form_validation->set_rules('tipoconcepto', 'lang:create_tipoconcepto_validation_name_label', 'required');
        $this->form_validation->set_rules('clase', 'lang:create_clase_validation_name_label','is_numeric|min_length[1]|max_length[1]');
    
        if (isset($_POST) && ! empty($_POST))
        {
            if ($this->form_validation->run() == TRUE)
            {
                if ($_POST['concepto']) {
                    $data['concepto']       = $_POST['concepto'];
                }

                if ($_POST['nombre']) {
                    $data['nombre']         = $_POST['nombre'];
                }

                if ($_POST['tipoconcepto']) {
                    $data['tipoconcepto']   = $_POST['tipoconcepto'];
                }

                
                $concepto_update = $this->conceptos_model->update_concepto($id, $data);
                
                if ($concepto_update)
                {
                    $this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
                    redirect('conceptos/conceptos/edit/'.$id);
                }
                else
                {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                }
            }
        }

        /* Load Template */     
        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        $this->data['conceptos']   = $conceptos;

           $this->data['concepto'] = array(
                'name'  => 'concepto',
                'id'    => 'concepto',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('concepto', $conceptos->concepto),
                'maxlength' => 25
            );
            $this->data['nombre'] = array(
                'name'  => 'nombre',
                'id'    => 'nombre',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('nombre', $conceptos->nombre),
                'maxlength' => 100
            );
            $this->data['tipoconcepto'] = array(
                'name'  => 'tipoconcepto',
                'id'    => 'tipoconcepto',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('tipoconcepto', $conceptos->tipoconcepto),
                'maxlength' => 100
            );
            $this->data['clase'] = array(
                'name'  => 'clase',
                'id'    => 'clase',
                'type'  => 'number',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('clase', $conceptos->clase),
                'max'   => 9
            );  

        $this->template->admin_render('conceptos/conceptos/index', $this->data);
    }

    public function delete($concepto){

        $concepto_delete = $this->conceptos_model->delete_concepto($concepto);

        if ($concepto_delete)
        {
            $this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
            redirect('conceptos/conceptos');
        }
        else
        {
            $this->session->set_flashdata('message', $this->ion_auth->errors());
        }
    
    }

}