<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clientes extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('clientes/Cliente_model');
        $this->lang->load('clientes/clientes_lang');
        $this->load->library('pagination');
    }

    public function index_bk()
    {

        // Obtener los filtros desde el formulario
        $filters = [
            'cedularuc' => $this->input->get('cedularuc'),
            'nombre' => $this->input->get('nombre'),
            'apellido' => $this->input->get('apellido'),
            'email' => $this->input->get('email')
        ];

        $user_id= $this->session->userdata('user_id');
        $tipo_usuario = $_SESSION['tipo_usuario'][0];
        $id_cliente = $_SESSION['id_cliente'][0];

        if ($tipo_usuario == 'C') {
            $filters['id_cliente'] = $id_cliente;                                 
        }


            /*
            echo '<pre>';
            echo 'Contenido de $_SESSION: ';
            print_r($_SESSION);
            //echo '</pre>';

            echo 'filters: ';
            print_r($filters);            
            echo '</pre>';
            */
            
            //show();

        $this->data['lang'] = $this->lang->load('clientes/clientes', 'spanish'); // Ajusta el idioma
        $this->data['charset'] = 'UTF-8';
        $this->data['mobile'] = FALSE;

        // Consultar datos usando filtros
        $data['clientes'] = $this->Cliente_model->get_clientes($filters);
        /* $this->load->view('clientes/index', $data); */
        $this->template->admin_render('clientes/index', array_merge($data, $this->data));
    }


    public function index() {
 
        // Obtener los filtros desde el formulario
        $filters = [
            'cedularuc' => $this->input->get('cedularuc'),
            'nombre' => $this->input->get('nombre'),
            'apellido' => $this->input->get('apellido'),
            'email' => $this->input->get('email')
        ];

        $user_id= $this->session->userdata('user_id');
        $tipo_usuario = $_SESSION['tipo_usuario'][0];
        $id_cliente = $_SESSION['id_cliente'][0];

        if ($tipo_usuario == 'C') {
            $filters['id_cliente'] = $id_cliente;                                 
        }

        $config['base_url'] = site_url('clientes/Clientes/index');      
        $config['total_rows'] = $this->Cliente_model->count_clientes($filters);
        $config['per_page'] = 10;

        $this->pagination->initialize($config);

        $this->data['lang'] = $this->lang->load('clientes/clientes', 'spanish'); // Ajusta el idioma
        $this->data['charset'] = 'UTF-8';
        //$this->data['mobile'] = FALSE;

        $data['clientes'] = $this->Cliente_model->get_clientes($filters, $config['per_page'], $this->uri->segment(4));
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;

        //$this->load->view('grupos/index', $data);
        $this->template->admin_render('clientes/index', array_merge($data, $this->data));
    }

    public function create()
    {
        // Validar datos del formulario
        $this->form_validation->set_rules('cedularuc', 'Cédula/RUC', 'required|numeric');
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');
        $this->form_validation->set_rules('apellido', 'Apellido', 'required');
        $this->form_validation->set_rules('tipo_persona', 'Tipo de Persona', 'required');
    
        if ($this->form_validation->run() === FALSE) {
            // Cargar la vista de creación con los datos necesarios
            $this->data['lang'] = $this->lang->load('clientes/clientes', 'spanish');
            $this->template->admin_render('clientes/create', $this->data);
        } else {
            // Preparar los datos para guardar
            $nuevo_cliente = [
                'cedularuc' => $this->input->post('cedularuc'),
                'nombre' => $this->input->post('nombre'),
                'apellido' => $this->input->post('apellido'),
                'email' => $this->input->post('email') ?: null,
                'fecha_nac' => $this->input->post('fecha_nac') ?: null,
                'sexo' => $this->input->post('sexo') ?: null,
                'tipo_persona' => $this->input->post('tipo_persona'),
                'telefono' => $this->input->post('telefono') ?: null,
                'direccion' => $this->input->post('direccion') ?: null,
                'tipo_empresa' => $this->input->post('tipo_empresa') ?: null,
                'nacionalidad' => $this->input->post('nacionalidad') ?: null,
                'rlegal_cedula' => $this->input->post('rlegal_cedula') ?: null,
                'rlegal_nombre' => $this->input->post('rlegal_nombre') ?: null,
                'rlegal_apellido' => $this->input->post('rlegal_apellido') ?: null,
                'rlegal_sexo' => $this->input->post('rlegal_sexo') ?: null,
                'dvi' => $this->input->post('dvi') ?: null,
            ];
    
            // Guardar datos en la base de datos
            if ($this->Cliente_model->insert_cliente($nuevo_cliente)) {
                $this->session->set_flashdata('message', 'Cliente creado correctamente.');
                redirect('clientes/clientes/index');
            } else {
                show_error('Error al crear el cliente.');
            }
        }
    }

    public function edit($id)
    {
        // Obtener datos del cliente por ID
        $data['cliente'] = $this->Cliente_model->get_cliente($id);

        if (!$data['cliente']) {
            show_404(); // Si el cliente no existe, muestra un error
        }

        // Validar datos del formulario
        $this->form_validation->set_rules('cedularuc', 'Cédula/RUC', 'required|numeric');
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');
        $this->form_validation->set_rules('apellido', 'Apellido', 'required');



        if ($this->form_validation->run() === FALSE) {

            // Obtener los tipos de d_tipopersona con ID y descripción
            $d_sexo = $this->Cliente_model->concepto('SEXO', false, 'CONCEPTO');
            $dropdown_sexo = ['' => 'Seleccione un Tipo de Riesgo'];
            foreach ($d_sexo as $r_sexo) {
                $dropdown_sexo[$r_sexo['concepto']] = $r_sexo['concepto'] . ' - ' . $r_sexo['nombre'];
            }
            $this->data['dropdown_sexo'] = $dropdown_sexo;	

            // Obtener los tipos de d_tipopersona con ID y descripción
            $d_tipopersona = $this->Cliente_model->concepto('TIPO_PERSONA', false, 'CONCEPTO');
            //$dropdown_tipopersona = ['' => 'Seleccione un Tipo de Persona'];
            foreach ($d_tipopersona as $r_tipopersona) {
                $dropdown_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'] . ' - ' . $r_tipopersona['nombre'];
            }
            $this->data['dropdown_tipopersona'] = $dropdown_tipopersona;	

            // Obtener los tipos de d_tipoempresa con ID y descripción
            $d_tipoempresa = $this->Cliente_model->concepto('TIPO_EMPRESA', false, 'CONCEPTO');
            $dropdown_tipoempresa = ['' => 'Seleccione un Tipo de Empresa'];
            foreach ($d_tipoempresa as $r_tipoempresa) {
                $dropdown_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'] . ' - ' . $r_tipoempresa['nombre'];
            }
            $this->data['dropdown_tipoempresa'] = $dropdown_tipoempresa;

            $this->data['lang'] = $this->lang->load('clientes/clientes', 'spanish');
            $this->template->admin_render('clientes/edit', array_merge($data, $this->data));
           

        } else {
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'cedularuc' => $this->input->post('cedularuc') ?: null,
                'nombre' => $this->input->post('nombre') ?: null,
                'apellido' => $this->input->post('apellido') ?: null,
                'email' => $this->input->post('email') ?: null,
                'fecha_nac' => $this->input->post('fecha_nac') ?: null,
                'sexo' => $this->input->post('sexo') ?: null,
                'tipo_persona' => $this->input->post('tipo_persona') ?: null,
                'telefono' => $this->input->post('telefono') ?: null,
                'direccion' => $this->input->post('direccion') ?: null,
                'tipo_empresa' => $this->input->post('tipo_empresa') ?: null,
                'nacionalidad' => $this->input->post('nacionalidad') ?: null,
                'rlegal_cedula' => $this->input->post('rlegal_cedula') ?: null,
                'rlegal_nombre' => $this->input->post('rlegal_nombre') ?: null,
                'rlegal_apellido' => $this->input->post('rlegal_apellido') ?: null,
                'rlegal_sexo' => $this->input->post('rlegal_sexo') ?: null,
                'dvi' => $this->input->post('dvi') ?: null,
            ];

			
            // Actualizar datos en la base de datos
            if ($this->Cliente_model->update_cliente($id, $datos_actualizados)) {
                $this->session->set_flashdata('message', 'Cliente actualizado correctamente.');
                redirect('clientes/clientes/edit/' . $id); // vuelve a la misma vista con el ID

            } else {
                redirect('clientes/clientes/edit/' . $id); // vuelve a la misma vista con el ID
                show_error('Error al actualizar el cliente.');
            }
        }
    }

    public function view($id)
    {
        // Obtener datos del cliente por ID
        $data['cliente'] = $this->Cliente_model->get_cliente($id);

        if (!$data['cliente']) {
            show_404(); // Si el cliente no existe, muestra un error
        }

        // Validar datos del formulario
        $this->form_validation->set_rules('cedularuc', 'Cédula/RUC', 'required|numeric');
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');
        $this->form_validation->set_rules('apellido', 'Apellido', 'required');



        if ($this->form_validation->run() === FALSE) {

            // Obtener los tipos de d_tipopersona con ID y descripción
            $d_sexo = $this->Cliente_model->concepto('SEXO', false, 'CONCEPTO');
            $dropdown_sexo = ['' => 'Seleccione un Tipo de Riesgo'];
            foreach ($d_sexo as $r_sexo) {
                $dropdown_sexo[$r_sexo['concepto']] = $r_sexo['concepto'] . ' - ' . $r_sexo['nombre'];
            }
            $this->data['dropdown_sexo'] = $dropdown_sexo;	

            // Obtener los tipos de d_tipopersona con ID y descripción
            $d_tipopersona = $this->Cliente_model->concepto('TIPO_PERSONA', false, 'CONCEPTO');
            $dropdown_tipopersona = ['' => 'Seleccione un Tipo de Persona'];
            foreach ($d_tipopersona as $r_tipopersona) {
                $dropdown_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'] . ' - ' . $r_tipopersona['nombre'];
            }
            $this->data['dropdown_tipopersona'] = $dropdown_tipopersona;	

            // Obtener los tipos de d_tipoempresa con ID y descripción
            $d_tipoempresa = $this->Cliente_model->concepto('TIPO_EMPRESA', false, 'CONCEPTO');
            $dropdown_tipoempresa = ['' => 'Seleccione un Tipo de Empresa'];
            foreach ($d_tipoempresa as $r_tipoempresa) {
                $dropdown_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'] . ' - ' . $r_tipoempresa['nombre'];
            }
            $this->data['dropdown_tipoempresa'] = $dropdown_tipoempresa;

            $this->data['lang'] = $this->lang->load('clientes/clientes', 'spanish');
            $this->template->admin_render('clientes/view', array_merge($data, $this->data));
                

        } else {
            // Preparar los datos para actualizar
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'cedularuc' => $this->input->post('cedularuc') ?: null,
                'nombre' => $this->input->post('nombre') ?: null,
                'apellido' => $this->input->post('apellido') ?: null,
                'email' => $this->input->post('email') ?: null,
                'fecha_nac' => $this->input->post('fecha_nac') ?: null,
                'sexo' => $this->input->post('sexo') ?: null,
                'tipo_persona' => $this->input->post('tipo_persona') ?: null,
                'telefono' => $this->input->post('telefono') ?: null,
                'direccion' => $this->input->post('direccion') ?: null,
                'tipo_empresa' => $this->input->post('tipo_empresa') ?: null,
                'nacionalidad' => $this->input->post('nacionalidad') ?: null,
                'rlegal_cedula' => $this->input->post('rlegal_cedula') ?: null,
                'rlegal_nombre' => $this->input->post('rlegal_nombre') ?: null,
                'rlegal_apellido' => $this->input->post('rlegal_apellido') ?: null,
                'rlegal_sexo' => $this->input->post('rlegal_sexo') ?: null,
                'dvi' => $this->input->post('dvi') ?: null,
            ];

			
            // Actualizar datos en la base de datos
            if ($this->Cliente_model->update_cliente($id, $datos_actualizados)) {
                $this->session->set_flashdata('message', 'Cliente actualizado correctamente.');
                redirect('clientes/clientes/index/');
            } else {
                show_error('Error al actualizar el cliente.');
            }
        }
    }

    public function delete($id)
    {
        $this->Cliente_model->delete_cliente($id);
        redirect('clientes/clientes/index/');
    } 
}


