<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pga extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Pga_model');
        $this->load->model('Tumba_model');
        $this->load->library('pagination');
    }

    public function index($id_proyecto = NULL) {
        $filters = $this->input->get();
        $filters['id_proyecto'] = $id_proyecto;
    
        $config['base_url'] = site_url('Pga/index/' . $id_proyecto . '?' . http_build_query($filters));
        $config['total_rows'] = $this->Pga_model->count_pgas($filters);
        $config['per_page'] = 10;
    
        $this->pagination->initialize($config);
    
        // Obtener lista de estados desde el modelo
        $estados = $this->Pga_model->concepto('PGA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['nombre']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        
        // Obtener nombre del proyecto
        $nombre_proyecto = $this->Pga_model->get_proyecto_nombre($id_proyecto);

        // Pasar datos a la vista
        $data['pgas'] = $this->Pga_model->get_all($filters, $config['per_page'], $this->uri->segment(4));
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['id_proyecto'] = $id_proyecto;
        $data['dropdown_estados'] = $dropdown_estados;
        $data['nombre_proyecto'] = $nombre_proyecto;
    

        // INICIO - Implementacion del codigo para guardar las fechar de PGA
        $toYmd = function($s){
            $s = trim((string)$s);
            if ($s === '') return null;
            // dd/mm/yyyy
            if (preg_match('~^(\d{2})/(\d{2})/(\d{4})$~', $s, $m)) {
                return "{$m[3]}-{$m[2]}-{$m[1]}";
            }
            // yyyy-mm-dd (ya en formato BD)
            if (preg_match('~^\d{4}-\d{2}-\d{2}$~', $s)) return $s;
            return null;
        };

        // POST: guardar desde el modal
        if ($this->input->post('guardar_pga')) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('pga', 'PGA', 'trim|max_length[255]');
            $this->form_validation->set_rules('pga_obs', 'Observación', 'trim|max_length[500]');
            $this->form_validation->set_rules('pga_fecha', 'Fecha', 'trim');
            $this->form_validation->set_rules('pga_fecha_fin', 'Fecha fin', 'trim');

            if ($this->form_validation->run()) {
                $u = $this->ion_auth->user()->row();
                $upd = [
                    'pga'           => $this->input->post('pga', true) ?: null,
                    'pga_obs'       => $this->input->post('pga_obs', true) ?: null,
                    'pga_fecha'     => $toYmd($this->input->post('pga_fecha')),
                    'pga_fecha_fin' => $toYmd($this->input->post('pga_fecha_fin')),
                    'pga_usu_modif' => $u ? $u->username : 'sistema',
                ];
                $this->db->where('gid', $id_proyecto)->update('ema.proyectos', $upd);
                $ok = ($this->db->affected_rows() >= 0);
                $this->session->set_flashdata($ok ? 'message' : 'error', $ok ? 'PGA actualizado.' : 'No se pudo guardar.');
                redirect(current_url());
            } else {
                $this->session->set_flashdata('error', validation_errors());
                redirect(current_url());
            }
        }

        // leer valores actuales para pintar la tarjetita
        $pga_note = $this->db->select('pga,pga_obs,pga_fecha,pga_fecha_fin,pga_usu_modif')
                            ->where('gid', $id_proyecto)
                            ->get('ema.proyectos')->row_array();

        // formatear fechas a dd/mm/yyyy para la vista
        $fmt = function($ymd){
            if (!$ymd) return '';
            $dt = DateTime::createFromFormat('Y-m-d', $ymd);
            return $dt ? $dt->format('d/m/Y') : $ymd;
        };
        if ($pga_note) {
            $pga_note['pga_fecha']     = $fmt($pga_note['pga_fecha'] ? isset($pga_note['pga_fecha']) : '');
            $pga_note['pga_fecha_fin'] = $fmt($pga_note['pga_fecha_fin'] ? isset($pga_note['pga_fecha_fin']) : '');
        }
        $data['pga_note'] = $pga_note;
        // FIN - Implementacion del codigo para guardar las fechar de PGA
        $this->template->admin_render('pga/index', array_merge($data, $this->data));
    }
    
    

    // Acción para crear un nuevo registro
    public function create($id_proyecto = NULL) {
        if ($this->input->post()) {
            // Guardar los datos del PGA
            $data = [
                'id_proyecto'   => $id_proyecto,
                'tipo_riesgo'   => $this->input->post('tipo_riesgo'),
                'tipo_plan'     => $this->input->post('tipo_plan'),
                'descript_plan' => $this->input->post('descript_plan'),
                'fecha_reg'     => date('Y-m-d', strtotime($this->input->post('fecha_reg'))),
                'estado'        => $this->input->post('estado'),
            ];
    
            // Insertar el PGA y obtener el ID generado
            $id_pga = $this->Pga_model->insert($data);
    
            if ($id_pga) {
                // Crear la carpeta de documentos para el PGA
                $folder_path = '/dir_ema/archivos/pga/' . $id_pga . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }
    
                // Subir documentos a la tabla `ema.tumba`
                if (!empty($_FILES['documento']['name'][0])) {
                    $tipo_documento = '2'; // Tipo de documento específico para PGA
                    $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id_pga, $tipo_documento);
    
                    if ($upload_result['status']) {
                        $this->session->set_flashdata('message', 'PGA y documentos guardados correctamente.');
                    } else {
                        $this->session->set_flashdata('error', 'Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                    }
                } else {
                    $this->session->set_flashdata('message', 'PGA creado sin documentos.');
                }
    
                // Redirigir a la lista de PGA
                redirect('pga/index/' . $id_proyecto);
            } else {
                $this->session->set_flashdata('error', 'No se pudo crear el PGA.');
                redirect('pga/index/' . $id_proyecto);
            }
        }

        // Obtener los estados
        $estados = $this->Pga_model->concepto('PGA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;

        // Obtener los tipos de riesgo
        $tipos_riesgo = $this->Pga_model->concepto('TIPO_RIESGO', false, 'CONCEPTO');
        $dropdown_tipos_riesgo = ['' => 'Seleccione un Tipo de Riesgo'];
        foreach ($tipos_riesgo as $riesgo) {
            $dropdown_tipos_riesgo[$riesgo['concepto']] = $riesgo['concepto'] . ' - ' . $riesgo['nombre'];
        }
        $this->data['dropdown_tipos_riesgo'] = $dropdown_tipos_riesgo;

        // Obtener los tipos de plan
        $tipos_plan = $this->Pga_model->concepto('TIPO_PLAN', false, 'CONCEPTO');
        $dropdown_tipos_plan = ['' => 'Seleccione un Tipo de Plan'];
        foreach ($tipos_plan as $plan) {
            $dropdown_tipos_plan[$plan['concepto']] = $plan['concepto'] . ' - ' . $plan['nombre'];
        }
        $this->data['dropdown_tipos_plan'] = $dropdown_tipos_plan;

        $this->data['id_proyecto'] = $id_proyecto;
        $this->data['pga'] = new stdClass(); // Crear un objeto vacío para evitar errores en la vista si $pga no existe
        $this->template->admin_render('pga/form_create', array_merge($this->data));
    }


    // Acción para editar un registro existente
    public function edit($id, $id_proyecto = NULL) {
        $data['documentos'] = $this->Tumba_model->get_documents_by_project($id, '2'); // Tipo 2 = Documentos de PGA
        if ($this->input->post()) {
            $data = [               
                'id_proyecto'   => $this->input->post('id_proyecto'),
                'tipo_riesgo'   => $this->input->post('tipo_riesgo'),
                'tipo_plan'     => $this->input->post('tipo_plan'),
                'descript_plan' => $this->input->post('descript_plan'),
                'fecha_reg'     => $this->input->post('fecha_reg'),
                'estado'        => $this->input->post('estado'),
            ];
            $this->Pga_model->update($id, $data);
            if (!empty($_FILES['documento']['name'][0])) {
                $folder_path = '/dir_ema/archivos/pga/' . $id . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }
                
                $tipo_documento = '2'; // Tipo de documento para PGA
                $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id, $tipo_documento);
    
                if ($upload_result['status']) {
                    $this->session->set_flashdata('message', 'PGA actualizado y documentos subidos correctamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                }
            } else {
                $this->session->set_flashdata('message', 'PGA actualizado sin nuevos documentos.');
            }
            //redirect('pga/index/' . $data['id_proyecto']);
            redirect('pga/edit/' . $id . '/' . $id_proyecto);
        }

        // Obtener el registro de PGA
        $data['pga'] = $this->Pga_model->get_all(['id' => $id])[0];
        $id_proyecto = $data['pga']->id_proyecto; // Aseguramos que $id_proyecto tiene valor correcto

        // Obtener los estados con ID y descripción
        $estados = $this->Pga_model->concepto('PGA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;

        // Obtener los tipos de riesgo con ID y descripción
        $tipos_riesgo = $this->Pga_model->concepto('TIPO_RIESGO', false, 'CONCEPTO');
        $dropdown_tipos_riesgo = ['' => 'Seleccione un Tipo de Riesgo'];
        foreach ($tipos_riesgo as $riesgo) {
            $dropdown_tipos_riesgo[$riesgo['concepto']] = $riesgo['concepto'] . ' - ' . $riesgo['nombre'];
        }
        $this->data['dropdown_tipos_riesgo'] = $dropdown_tipos_riesgo;

        // Obtener los tipos de plan con ID y descripción
        $tipos_plan = $this->Pga_model->concepto('TIPO_PLAN', false, 'CONCEPTO');
        $dropdown_tipos_plan = ['' => 'Seleccione un Tipo de Plan'];
        foreach ($tipos_plan as $plan) {
            $dropdown_tipos_plan[$plan['concepto']] = $plan['concepto'] . ' - ' . $plan['nombre'];
        }
        $this->data['dropdown_tipos_plan'] = $dropdown_tipos_plan;

        // Pasar el ID del proyecto a la vista
        $this->data['id_proyecto'] = $id_proyecto;
        
        $this->template->admin_render('pga/form_edit', array_merge($data, $this->data));      
    }

    public function delete_document($id_documento, $tipo_documento = '2',$id_proyecto = NULL) {
		// Obtener el ID del proyecto asociado al documento
		$proyecto = $this->Tumba_model->get_project_by_document($id_documento, $tipo_documento);
	
		if ($this->Tumba_model->delete_document($id_documento, $tipo_documento)) {
			$this->session->set_flashdata('message', 'Documento eliminado correctamente.');
		} else {
			$this->session->set_flashdata('error', 'No se pudo eliminar el documento. Verifica el tipo de documento.');
		}
		redirect('pga/edit/' . $proyecto->id_documento .'/'.$id_proyecto);
		
	}

    public function views($id, $id_proyecto = NULL) {
        if ($this->input->post()) {
            $data = [               
                'id_proyecto'   => $this->input->post('id_proyecto'),
                'tipo_riesgo'   => $this->input->post('tipo_riesgo'),
                'tipo_plan'     => $this->input->post('tipo_plan'),
                'descript_plan' => $this->input->post('descript_plan'),
                'fecha_reg'     => $this->input->post('fecha_reg'),
                'estado'        => $this->input->post('estado'),
            ];
            $this->Pga_model->update($id, $data);
            redirect('pga/index/' . $data['id_proyecto']);
        }

        // Obtener el registro de PGA
        $data['pga'] = $this->Pga_model->get_all(['id' => $id])[0];
        $id_proyecto = $data['pga']->id_proyecto; // Aseguramos que $id_proyecto tiene valor correcto

        // Obtener los estados con ID y descripción
        $estados = $this->Pga_model->concepto('PGA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;

        // Obtener los tipos de riesgo con ID y descripción
        $tipos_riesgo = $this->Pga_model->concepto('TIPO_RIESGO', false, 'CONCEPTO');
        $dropdown_tipos_riesgo = ['' => 'Seleccione un Tipo de Riesgo'];
        foreach ($tipos_riesgo as $riesgo) {
            $dropdown_tipos_riesgo[$riesgo['concepto']] = $riesgo['concepto'] . ' - ' . $riesgo['nombre'];
        }
        $this->data['dropdown_tipos_riesgo'] = $dropdown_tipos_riesgo;

        // Obtener los tipos de plan con ID y descripción
        $tipos_plan = $this->Pga_model->concepto('TIPO_PLAN', false, 'CONCEPTO');
        $dropdown_tipos_plan = ['' => 'Seleccione un Tipo de Plan'];
        foreach ($tipos_plan as $plan) {
            $dropdown_tipos_plan[$plan['concepto']] = $plan['concepto'] . ' - ' . $plan['nombre'];
        }
        $this->data['dropdown_tipos_plan'] = $dropdown_tipos_plan;

        // Pasar el ID del proyecto a la vista
        $this->data['id_proyecto'] = $id_proyecto;
        
        $this->template->admin_render('pga/form_views', array_merge($data, $this->data));      
    }
    

        
    public function delete($id,$id_proyecto=NULL) {
        $this->Pga_model->delete($id);
        redirect('pga/index/'.$id_proyecto);
    }
}
