<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dpto extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Dpto_model');
        $this->load->library('pagination');
        $this->load->library('form_validation');
    }

    public function index() {
        $filters = $this->input->get();
        if (isset($filters['per_page'])) {
            unset($filters['per_page']);
        }

        $config['base_url'] = site_url('dpto/index') . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Dpto_model->count_departamentos($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }

        $data['departamentos'] = $this->Dpto_model->get_departamentos($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Listado de Departamentos';

        $this->template->admin_render('dpto/index', array_merge($data, $this->data));
    }

    public function create() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('dpto', 'Código', 'required');
            $this->form_validation->set_rules('dpto_desc', 'Descripción', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['pagetitle'] = 'Crear Departamento';
                $this->template->admin_render('dpto/create', array_merge($data, $this->data));
            } else {
                $data_insert = [
                    'dpto' => $this->input->post('dpto'),
                    'dpto_desc' => $this->input->post('dpto_desc'),
                    'cod' => $this->input->post('cod'),
                    'region' => $this->input->post('region'),
                    'shape_leng' => $this->input->post('shape_leng'),
                    'shape_area' => $this->input->post('shape_area'),
                    'dpto_snc' => $this->input->post('dpto_snc'),
                ];

                if ($this->Dpto_model->create_dpto($data_insert)) {
                    $this->session->set_flashdata('message', 'Departamento creado exitosamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al crear el departamento.');
                }
                redirect('dpto');
            }
        } else {
            $data['pagetitle'] = 'Crear Departamento';
            $this->template->admin_render('dpto/create', array_merge($data, $this->data));
        }
    }

    public function edit($id) {
        $dpto = $this->Dpto_model->get_dpto_by_id($id);
        if (!$dpto) {
            show_404();
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('dpto', 'Código', 'required');
            $this->form_validation->set_rules('dpto_desc', 'Descripción', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['departamento'] = $dpto;
                $data['pagetitle'] = 'Editar Departamento';
                $this->template->admin_render('dpto/edit', array_merge($data, $this->data));
            } else {
                $data_update = [
                    'dpto' => $this->input->post('dpto'),
                    'dpto_desc' => $this->input->post('dpto_desc'),
                    'cod' => $this->input->post('cod'),
                    'region' => $this->input->post('region'),
                    'shape_leng' => $this->input->post('shape_leng'),
                    'shape_area' => $this->input->post('shape_area'),
                    'dpto_snc' => $this->input->post('dpto_snc'),
                ];

                if ($this->Dpto_model->update_dpto($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Departamento actualizado correctamente.');
                    redirect('dpto');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar el departamento.');
                    redirect('dpto/edit/' . $id);
                }
            }
        } else {
            $data['departamento'] = $dpto;
            $data['pagetitle'] = 'Editar Departamento';
            $this->template->admin_render('dpto/edit', array_merge($data, $this->data));
        }
    }

    public function delete($id) {
        if ($this->Dpto_model->delete_dpto($id)) {
            $this->session->set_flashdata('message', 'Departamento eliminado correctamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar el departamento.');
        }
        redirect('dpto');
    }
}
?>
