<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departamentos extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Departamentos_model');
        $this->load->library(['pagination', 'form_validation']);
    }

    public function index() {
        $filters = $this->input->get();

        $config['base_url'] = site_url('departamentos/index') . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Departamentos_model->count_departamentos($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }

        $data['departamentos'] = $this->Departamentos_model->get_departamentos($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Lista de Departamentos';

        $this->template->admin_render('departamentos/index', array_merge($data, $this->data));
    }

    public function view($id) {
        $data['departamento'] = $this->Departamentos_model->get_departamento_by_id($id);
        
        if (!$data['departamento']) {
            show_404();
        }
        
        $this->template->admin_render('departamentos/view', array_merge($data, $this->data));
    }
}
