<?php
class Declaraciones extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Declaraciones_model');
        $this->load->model('Tumba_model');
        $this->load->helper('url');
        $this->load->library('pagination');
    }

    public function index($id_proyecto = NULL) {
    
        // Obtener filtros desde GET
        $filters = $this->input->get();
        $filters['id_proyecto'] = $id_proyecto;
        
        // Definir paginación
        $per_page = 10;
        // Suponiendo que el segmento 4 contenga el offset
        $offset = $this->uri->segment(4, 0);
        
        // Agregar parámetros de paginación a los filtros
        $filters['limit'] = $per_page;
        $filters['offset'] = $offset;
        
        // Configurar URL base para paginación
        $config['base_url'] = site_url('declaraciones/index/' . $id_proyecto . '?' . http_build_query($filters));
        $config['total_rows'] = $this->Declaraciones_model->count_declaraciones($filters);
        $config['per_page'] = $per_page;
        
        $this->pagination->initialize($config);
        
        // Obtener lista de estados desde el modelo
        $estados = $this->Declaraciones_model->concepto('DECLA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['nombre']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        
        // Obtener nombre del proyecto
        $nombre_proyecto = $this->Declaraciones_model->get_proyecto_nombre($id_proyecto);
        
        // Obtener declaraciones con los filtros aplicados
        $data['declaraciones'] = $this->Declaraciones_model->get_declaraciones($filters);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['id_proyecto'] = $id_proyecto;
        $data['dropdown_estados'] = $dropdown_estados;
        $data['nombre_proyecto'] = $nombre_proyecto;
        
        // --- INICIO - IMPLEMETACION DE LAS FECHAS DE DECLARACIONES ---
        $nota_dia = $this->db->select('dia, dia_fecha, dia_obs, dia_usu_modif, dia_fecha_fin')
                     ->where('gid', $id_proyecto)
                     ->get('ema.proyectos')
                     ->row_array();
        if (!$nota_dia) {
            $nota_dia = array(
                'dia' => '', 'dia_fecha' => '', 'dia_obs' => '',
                'dia_usu_modif' => '', 'dia_fecha_fin' => ''
            );
        }
        $data['nota_dia'] = $nota_dia;

        // --- GUARDADO desde el modal ---
        if ($this->input->post('guardar_dia_meta')) {

            $this->load->library('form_validation');
            $this->form_validation->set_rules('dia', 'DIA', 'trim|max_length[255]');
            $this->form_validation->set_rules('dia_obs', 'Observación', 'trim|max_length[500]');
            $this->form_validation->set_rules('dia_fecha', 'Fecha', 'trim');        // yyyy-mm-dd
            $this->form_validation->set_rules('dia_fecha_fin', 'Fecha Fin', 'trim');// yyyy-mm-dd

            if ($this->form_validation->run()) {
                // Usuario logueado (IonAuth)
                $usuario   = $this->ion_auth->user()->row();
                $usu_modif = (isset($usuario->username) && $usuario->username) ? $usuario->username : 'sistema';

                $upd = array(
                    'dia'           => $this->input->post('dia', true) ? $this->input->post('dia', true) : NULL,
                    'dia_obs'       => $this->input->post('dia_obs', true) ? $this->input->post('dia_obs', true) : NULL,
                    'dia_fecha'     => $this->input->post('dia_fecha') ? $this->input->post('dia_fecha') : NULL,
                    'dia_fecha_fin' => $this->input->post('dia_fecha_fin') ? $this->input->post('dia_fecha_fin') : NULL,
                    'dia_usu_modif' => $usu_modif
                );

                $this->db->where('gid', $id_proyecto)->update('ema.proyectos', $upd);
                $ok = ($this->db->affected_rows() >= 0);
                $this->session->set_flashdata('message', $ok ? 'Datos de DIA guardados.' : 'No se pudo guardar.');
                redirect(current_url());
            } else {
                $this->session->set_flashdata('message', validation_errors());
                redirect(current_url());
            }
        }
        // --- FIN - IMPLEMETACION DE LAS FECHAS DE DECLARACIONES ---
        
        $this->template->admin_render('declaraciones/index', array_merge($data, $this->data));
    }
    
    

    public function create($id_proyecto = NULL) 
    {
        if ($this->input->post()) {
            $data = [               
                'id_proyecto' => $this->input->post('id_proyecto'),    
            ];
            $id_proyecto = $data['id_proyecto'];
        }
    
        // Reglas de validación
        $this->form_validation->set_rules('nro_declaracion', 'Número de Declaración', 'required|numeric');
        $this->form_validation->set_rules('gestion_declaracion', 'Gestión', 'required|numeric');
        $this->form_validation->set_rules('estado', 'Estado', 'required');
        $this->form_validation->set_rules('fecha_declaracion', 'Fecha de Declaración', 'required');
        $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento');
    
        // Obtener los estados
        $estados = $this->Declaraciones_model->concepto('DECLA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;
    
        if ($this->form_validation->run() === FALSE) {
            $data['id_proyecto'] = $id_proyecto;
            $this->template->admin_render('declaraciones/create', array_merge($data, $this->data));
        } else {
            $data = [
                'id_proyecto' => $this->input->post('id_proyecto'),
                'nro_declaracion' => $this->input->post('nro_declaracion'),
                'gestion_declaracion' => $this->input->post('gestion_declaracion'),
                'estado' => $this->input->post('estado'),
                'fecha_declaracion' => $this->input->post('fecha_declaracion'),
                'fecha_declaracion_vto' => $this->input->post('fecha_declaracion_vto'),
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa'),
                'observacion' => $this->input->post('observacion'),
            ];
    
            $id_declaracion = $this->Declaraciones_model->create_declaracion($data);
    
            if ($id_declaracion === 'duplicado') {
                $this->session->set_flashdata('error', '⚠️ Ya existe una declaración con ese número y gestión.');
                $data['id_proyecto'] = $id_proyecto;
                $this->template->admin_render('declaraciones/create', array_merge($data, $this->data));
                return;
            }
    
            if ($id_declaracion) {
                $folder_path = '/dir_ema/archivos/declaraciones/' . $id_declaracion . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }
    
                if (!empty($_FILES['documento']['name'][0])) {
                    $tipo_documento = '3';
                    $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id_declaracion, $tipo_documento);
    
                    if ($upload_result['status']) {
                        $this->session->set_flashdata('message', '✅ Declaración y documentos guardados correctamente.');
                    } else {
                        $this->session->set_flashdata('error', '❌ Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                    }
                } else {
                    $this->session->set_flashdata('message', '✅ Declaración creada sin documentos.');
                }
    
                redirect('declaraciones/index/' . $id_proyecto);
            } else {
                $this->session->set_flashdata('error', '❌ No se pudo crear la declaración. Intente nuevamente.');
                $this->template->admin_render('declaraciones/create', array_merge($data, $this->data));
            }
        }
    }

    // Editar una declaración existente
    public function edit($id,$id_proyecto=NULL)
    {
        $data['documentos'] = $this->Tumba_model->get_documents_by_project($id, '3');
        if ($this->input->post()) {
            $data = [               
                'id_proyecto'   => $this->input->post('id_proyecto'),    
            ];
            $id_proyecto = $data['id_proyecto'];
        }
        // Obtener datos de la declaración por ID
        $data['declaracion'] = $this->Declaraciones_model->get_declaracion_by_id($id);
        // Obtener documentos relacionado

        if (!$data['declaracion']) {
            show_404(); // Si la declaración no existe, muestra un error
        }

        // Validar datos del formulario
        $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
        $this->form_validation->set_rules('nro_declaracion', 'Número de Declaración', 'required|numeric');
        $this->form_validation->set_rules('gestion_declaracion', 'Gestión de Declaración', 'required|numeric');
        $this->form_validation->set_rules('estado', 'Estado', 'required|alpha');

        // Obtener los estados
        $estados = $this->Declaraciones_model->concepto('DECLA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;

        if ($this->form_validation->run() === FALSE) {
            // Cargar la vista con el formulario y errores de validación
            $this->data['id_proyecto'] = $id_proyecto;
            $this->data['lang'] = $this->lang->load('declaraciones/declaraciones', 'spanish');
            $this->template->admin_render('declaraciones/edit', array_merge($data, $this->data));
        } else {
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'id_proyecto' => $this->input->post('id_proyecto') ?: null,
                'nro_declaracion' => $this->input->post('nro_declaracion') ?: null,
                'gestion_declaracion' => $this->input->post('gestion_declaracion') ?: null,
                'fecha_declaracion' => $this->input->post('fecha_declaracion') ?: null,
                'fecha_declaracion_vto' => $this->input->post('fecha_declaracion_vto') ?: null,
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa') ?: null,
                'estado' => $this->input->post('estado') ?: null,
                'observacion' => $this->input->post('observacion') ?: null,
            ];
            $this->datos_actualizados['id_proyecto']  = $id_proyecto;
            // Actualizar datos en la base de datos
            // Lógica para subir documentos
            if (!empty($_FILES['documento']['name'][0])) {
                $folder_path = '/dir_ema/archivos/declaraciones/' . $id . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }

                $tipo_documento = '3'; // Tipo de documento
                $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id, $tipo_documento);

                if ($upload_result['status']) {
                    $this->session->set_flashdata('message', 'Declaración actualizada y documentos subidos correctamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                }
            } else {
                $this->session->set_flashdata('message', 'Declaración actualizada sin nuevos documentos.');
            }
            if ($this->Declaraciones_model->update_declaracion($id, $datos_actualizados)) {
                $this->session->set_flashdata('message', 'Declaración actualizada correctamente.');
                redirect('declaraciones/edit/' .$id. '/' .$id_proyecto);
            } else {
                show_error('Error al actualizar la declaración.');
            }
        }
    }

    public function delete_document($id_documento, $id_proyecto = NULL) {
        $this->load->model('Tumba_model'); // Cargar el modelo
    
        // Obtener el ID del proyecto al que pertenece el documento
        $proyecto = $this->Tumba_model->get_project_by_document($id_documento, '3');
    
        if ($this->Tumba_model->delete_document($id_documento, '3')) {
            $this->session->set_flashdata('message', 'Documento eliminado correctamente.');
        } else {
            $this->session->set_flashdata('error', 'No se pudo eliminar el documento.');
        }
    
        // Redirigir de vuelta a la vista de edición
        redirect('declaraciones/edit/' . $proyecto->id_documento . '/' . $id_proyecto);
    }
    

    public function views($id,$id_proyecto=NULL)
    {
        if ($this->input->post()) {
            $data = [               
                'id_proyecto'   => $this->input->post('id_proyecto'),    
            ];
            $id_proyecto = $data['id_proyecto'];
        }
        // Obtener datos de la declaración por ID
        $data['declaracion'] = $this->Declaraciones_model->get_declaracion_by_id($id);
        // Obtener el nombre del proyecto por el ID
        $nombre_proyecto = $this->Declaraciones_model->get_proyecto_nombre($id_proyecto);

        // Pasar el nombre del proyecto a la vista
        $data['nombre_proyecto'] = $nombre_proyecto;

        if (!$data['declaracion']) {
            show_404(); // Si la declaración no existe, muestra un error
        }

        // Obtener los estados
        $estados = $this->Declaraciones_model->concepto('DECLA_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
        $this->data['dropdown_estados'] = $dropdown_estados;

        if ($this->form_validation->run() === FALSE) {
            // Cargar la vista con el formulario y errores de valida
            $this->data['lang'] = $this->lang->load('declaraciones/declaraciones', 'spanish');
            $this->template->admin_render('declaraciones/views', array_merge($data, $this->data));
        } else {
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'id_proyecto' => $this->input->post('id_proyecto') ?: null,
                'nro_declaracion' => $this->input->post('nro_declaracion') ?: null,
                'gestion_declaracion' => $this->input->post('gestion_declaracion') ?: null,
                'fecha_declaracion' => $this->input->post('fecha_declaracion') ?: null,
                'fecha_declaracion_vto' => $this->input->post('fecha_declaracion_vto') ?: null,
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa') ?: null,
                'estado' => $this->input->post('estado') ?: null,
                'observacion' => $this->input->post('observacion') ?: null,
            ];

            // Actualizar datos en la base de datos
            $this->datos_actualizados['id_proyecto']  = $id_proyecto;
            if ($this->Declaraciones_model->update_declaracion($id, $datos_actualizados)) {
                $this->session->set_flashdata('message', 'Declaración actualizada correctamente.');
                redirect('declaraciones/index/'.$id_proyecto);
            } else {
                show_error('Error al actualizar la declaración.');
            }
        }
    }

    public function delete($id, $id_proyecto=NULL) {
        $this->Declaraciones_model->delete_declaracion($id);
        redirect('declaraciones/index/'.$id_proyecto);
    }
}
