<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px;
        }
        .btn-container .btn {
            margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('message')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('message'); ?>
            </div>
        <?php endif; ?>
    </section>

    <section class="content">
        <div class="container mt-5">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Crear Evaluación de Proyecto</h4>
                </div>
                <div class="card-body">
                    <form action="<?= site_url('proyectos_evaluaciones/create') ?>" method="post">
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="proyecto_id">ID del Proyecto</label>
                                <input type="number" class="form-control" name="proyecto_id" id="proyecto_id" value="<?= set_value('proyecto_id', isset($id_proyecto) ? $id_proyecto : '') ?>" required readonly>
                                <?= form_error('proyecto_id', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="form-group col-md-8">
                                <label for="categoria">Categoría</label>
                                <select class="form-control" name="categoria" id="categoria" required>
                                    <option value="">Seleccione una categoría</option>
                                    <option value="Dirección DGCCARN - Análisis Técnico">Dirección DGCCARN - Análisis Técnico</option>
                                    <option value="Geomática">Geomática</option>
                                    <option value="Recursos Hídricos">Recursos Hídricos</option>
                                    <option value="Sustancias Tóxicas">Sustancias Tóxicas</option>
                                    <option value="Dirección de Asesoría Jurídica">Dirección de Asesoría Jurídica</option>
                                    <option value="RIMA (Publicación) - 3 días">RIMA (Publicación) - 3 días</option>
                                    <option value="RIMA (WEB) - 10 días hábiles">RIMA (WEB) - 10 días hábiles</option>
                                    <option value="DVIA">DVIA</option>
                                    <option value="Dirección General">Dirección General</option>
                                    <option value="Licencia">Licencia</option>
                                </select>
                                <?= form_error('categoria', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label for="categoria" class="form-label">categoria</label>
                                <select name="categoria" id="categoria" class="form-control">
                                    <?php foreach ($dropdown_estados as $key => $value): ?>
                                        <option value="<?php echo $key; ?>" 
                                            <?php echo isset($_POST['estado']) && $_POST['estado'] == $key ? 'selected' : ''; ?>>
                                            <?php echo $value; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="estado">Estado</label>
                                <select name="estado" id="estado" class="form-control">
                                    <option value="1">Presentado</option>
                                    <option value="2">Aprobado</option>
                                    <option value="3">Rechazado</option>
                                    <option value="0">No Requiere</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="si_no">Aprobado (Sí/No)</label>
                                <select name="si_no" id="si_no" class="form-control">
                                    <option value="1">Sí</option>
                                    <option value="0">N/A</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="fecha">Fecha</label>
                                <input type="date" class="form-control" name="fecha" id="fecha">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="observaciones">Observaciones</label>
                                <textarea class="form-control" name="observaciones" id="observaciones" rows="3"></textarea>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="btn-container">
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                    <a href="<?= base_url('proyectos_evaluaciones/index/'.$id_proyecto) ?>" class="btn btn-warning">Cancelar</a>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
