<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-primary {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <!-- Puedes agregar breadcrumbs o títulos aquí -->
        </section>

        <section class="content">
            <div class="container mt-5">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4>Editar Declaración</h4>
                    </div>
                    <div class="card-body">
                        <form action="" method="post">

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="nombre_proyecto">Nombre del Proyecto</label>
                                    <input type="text" id="nombre_proyecto" name="nombre_proyecto" value="<?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?>" class="form-control" readonly>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="nro_declaracion">Número de Declaración</label>
                                    <input type="number" class="form-control" name="nro_declaracion" id="nro_declaracion" value="<?= set_value('nro_declaracion', $declaracion['nro_declaracion']) ?>" readonly>
                                    <?= form_error('nro_declaracion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="gestion_declaracion">Gestión de Declaración</label>
                                    <input type="number" class="form-control" name="gestion_declaracion" id="gestion_declaracion" value="<?= set_value('gestion_declaracion', $declaracion['gestion_declaracion']) ?>" readonly>
                                    <?= form_error('gestion_declaracion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            <div class="form-group col-md-6">
                                <label for="estado">Estado</label>
                                <select name="estado" id="estado" class="form-control" readonly>
                                    <?php foreach ($dropdown_estados as $key => $value): ?>
                                        <option value="<?php echo $key; ?>"
                                            <?php 
                                                $estado_actual = isset($_POST['estado']) ? $_POST['estado'] : $declaracion['estado']; 
                                                echo ($estado_actual == $key) ? 'selected' : ''; 
                                            ?>>
                                            <?php echo $value; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="fecha_declaracion">Fecha de Declaración</label>
                                    <input type="date" class="form-control" name="fecha_declaracion" id="fecha_declaracion" value="<?= set_value('fecha_declaracion', $declaracion['fecha_declaracion']) ?>" readonly>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="fecha_declaracion_vto">Fecha de Vencimiento</label>
                                    <input type="date" class="form-control" name="fecha_declaracion_vto" id="fecha_declaracion_vto" value="<?= set_value('fecha_declaracion_vto', $declaracion['fecha_declaracion_vto']) ?>" readonly>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="fecha_prox_vto_aa">Fecha Próximo Vencimiento AA</label>
                                    <input type="date" class="form-control" name="fecha_prox_vto_aa" id="fecha_prox_vto_aa" value="<?= set_value('fecha_prox_vto_aa', $declaracion['fecha_prox_vto_aa']) ?>" readonly>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="form-group col-md-12">
                                    <label for="observacion">Observación</label>
                                    <textarea class="form-control" name="observacion" id="observacion" rows="3" readonly><?= set_value('observacion', $declaracion['observacion']) ?></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="form-group col-md-12">
                                    <a href="<?= site_url('declaraciones/index/'. $declaracion['id_proyecto']) ?>" class="btn btn-warning">Cancelar</a>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
