<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
        </section>
        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4">Listado de Actividades</h1>
                <a href="<?= site_url('actividades/create') ?>" class="btn btn-primary mb-3">
                    <i class="fa fa-plus"></i> Crear Actividad
                </a>
                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Descripción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($actividades as $actividad): ?>
                                    <tr>
                                        <td>
                                            <a href="<?= site_url('actividades/edit/' . $actividad->id) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp;
                                            <a href="<?= site_url('actividades/delete/' . $actividad->id) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                        </td>
                                        <td><?= htmlspecialchars($actividad->id, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($actividad->descripcion, ENT_QUOTES, 'UTF-8') ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="pagination">
                    <?= $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>