<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px;
        }
        .btn-container .btn {
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger">
                    <?= $this->session->flashdata('error'); ?>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('message')): ?>
                <div class="alert alert-success">
                    <?= $this->session->flashdata('message'); ?>
                </div>
            <?php endif; ?>
        </section>
        <section class="content">
            <div class="container mt-5">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4>Editar Actividad</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?= site_url('actividades/edit/' . $actividad['id']) ?>" method="post">
                            <div class="form-group">
                                <label for="descripcion">Descripción</label>
                                <input type="text" class="form-control" name="descripcion" id="descripcion" value="<?= set_value('descripcion', $actividad['descripcion']) ?>" required>
                                <?= form_error('descripcion', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="btn-container">
                                <button type="submit" class="btn btn-primary">Guardar</button>
                                <a href="<?= base_url('actividades/index') ?>" class="btn btn-warning">Cancelar</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
