<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Parcelas_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * parcelas
	 *		
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view_all()
	{
		//$this->trigger_events('parcelas');

		// run each where that was passed
		
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['parcelas']);
		
		return $this;
	}




	/**
	 * proyecto
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view($dpto = NULL, $dist = NULL, $col = NULL)
	{
		$this->trigger_events('proyecto');

		if (isset($dpto) AND isset($dist) AND isset($col))
		{
			$this->where($this->tables['parcelas'].'.dpto_cod', $dpto);
			$this->where($this->tables['parcelas'].'.dist_cod', $dist);
			$this->where($this->tables['parcelas'].'.col_cod', $col);
		}

		$this->limit(1);
		$this->order_by('gid');
		
		//$this->db->query("SELECT FROM INDERT.parcelas WHERE gid = $id")

		return $this->view_all();
	}


	
	/**
	 * create_proyecto
	 *
	 * @author aditya menon
	*/
	public function create_proyecto($proyecto_dpto_cod = '', $proyecto_dist_cod = '', $proyecto_col_cod = '', $proyecto_id_codgeo = '', $proyecto_nombre = '', $additional_data = array())
	{
		// bail if the dpto_cod was not passed ** Se utiliza la etiqueta de lenguaje spanish
		if(!$proyecto_dpto_cod)
		{
			$this->set_error('proyecto_dpto_cod_required');
			return FALSE;
		}
		// bail if the dist_cod was not passed
		if(!$proyecto_dist_cod)
		{
			$this->set_error('proyecto_dist_cod_required');
			return FALSE;
		}
		// bail if the col_cod was not passed
		if(!$proyecto_col_cod)
		{
			$this->set_error('proyecto_col_cod_required');
			return FALSE;
		}
		// bail if the id_codgeo was not passed
		if(!$proyecto_id_codgeo)
		{
			$this->set_error('proyecto_id_codgeo_required');
			return FALSE;
		}
		// bail if the nombre was not passed
		if(!$proyecto_nombre)
		{
			$this->set_error('proyecto_nombre_required');
			return FALSE;
		}		
		// bail if the group name already exists
		$existing_proyecto = $this->db->get_where($this->tables['parcelas'], array('nombre' => $proyecto_nombre))->num_rows();

		
		if($existing_proyecto !== 0)
		{
			$this->set_error('proyecto_already_exists');
			return FALSE;
		}
		
		$data = array('dpto_cod'=>$proyecto_dpto_cod, 'dist_cod'=>$proyecto_dist_cod, 'col_cod'=>$proyecto_col_cod, 'id_codgeo'=>$proyecto_id_codgeo, 'nombre'=>$proyecto_nombre, 'nombre'=>$proyecto_nombre);
		
		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['parcelas'], $additional_data), $data);

		$this->trigger_events('extra_proyecto_set');

		// insert the new group
		$this->db->insert($this->tables['parcelas'], $data);
		$proyecto_gid = $this->db->insert_id();

		// report success
		$this->set_message('proyecto_creation_successful');
		// return the brand new group id
		return $proyecto_gid;
	}
	
	/**
	 * update_gepcolonia
	 *
	 * @return bool
	 * @author aditya menon
	 **/

    public function update_proyecto($gid = FALSE, $proyecto_dpto_cod = FALSE, $proyecto_dist_cod = FALSE, $proyecto_col_cod = FALSE, $proyecto_id_codgeo = FALSE, $proyecto_nombre = FALSE, $additional_data = array())
	{
		if (empty($gid) AND empty($proyecto_dpto_cod) AND empty($proyecto_dist_cod) AND empty($proyecto_col_cod) AND empty($proyecto_id_codgeo) AND empty($proyecto_nombre)) return FALSE;

		$data = array();

		if (!empty($gid) AND !empty($proyecto_dpto_cod) AND !empty($proyecto_dist_cod) AND !empty($proyecto_col_cod) AND !empty($proyecto_id_codgeo) AND !empty($proyecto_nombre))
		{
			// we are changing the nombre, so do some checks

			// bail if the proyecto nombre already exists
			$existing_proyecto = $this->db->get_where($this->tables['parcelas'], array('dpto_cod' => $proyecto_dpto_cod, 'dist_cod' => $proyecto_dist_cod, 'col_cod' => $proyecto_col_cod, 'id_codgeo' => $proyecto_id_codgeo))->row();

			if(isset($existing_proyecto->gid) && $existing_proyecto->gid != $gid)
			{
				$this->set_error('proyecto_already_exists');
				return FALSE;
			}
			/*
			if (strlen($proyecto_dpto_cod) > 2) 
			{
				$this->set_error('proyecto_already_exists');
				return FALSE;
			}
			*/
			$data['dpto_cod'] = $proyecto_dpto_cod;
			$data['dist_cod'] = $proyecto_dist_cod;
			$data['col_cod'] = $proyecto_col_cod;
			$data['id_codgeo'] = $proyecto_id_codgeo;
			$data['nombre'] = $proyecto_nombre;
		}

		// restrict change of name of the admin group
        $proyecto = $this->db->get_where($this->tables['parcelas'], array('gid' => $gid))->row();
        
        /*if($this->config->item('admin_group', 'ion_auth') === $proyecto->dpto_cod && $proyecto_dpto_cod !== $proyecto->dpto_cod)
        {
            $this->set_error('group_name_admin_not_alter');
            return FALSE;
        }*/

		// IMPORTANT!! Third parameter was string type $description; this following code is to maintain backward compatibility
		// New projects should work with 3rd param as array
		if (is_string($additional_data)) $additional_data = array('col_cod' => $additional_data);


		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['parcelas'], $additional_data), $data);


		$this->db->update($this->tables['parcelas'], $data, array('gid' => $gid));

		$this->set_message('parcelas_update_successful');

		return TRUE;
	}



	public function departamentos()
	{
		$this->response = $this->db->get($this->tables['departamentos']);

		return $this;
	}

	public function distritos()
	{
		$this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
		return $this;
	}

	//PAGINATION
	public function get_pagination($number_per_page,$datos)
	{
		if ($this->uri->segment(5) == null | $this->uri->segment(5) == '') {
			if ($datos !== null) {
				$this->response = $this->db->get_where($this->tables['parcelas'],$datos,$number_per_page, 0);
			}else{

				$this->response = $this->db->get($this->tables['parcelas'],$number_per_page, 0);
			}
			
		}else
		{
			if ($datos !== null) {
				$this->response = $this->db->get($this->tables['parcelas'],$datos,$number_per_page, $this->uri->segment(5));
			}else{
				
				$this->response = $this->db->get($this->tables['parcelas'],$number_per_page, $this->uri->segment(5));
			}
			
		}
		
		return $this;
	}

	public function num_post_parcelas($where)
	{	

		$number = $this->db->query("SELECT count(*) as number FROM i3geo.parcelas")->row()->number; //rápido
		return intval($number);
	}



	public function obtener_gid_poligono($id_proyecto)
	{



			$i_sql = "select * ";			
            $i_sql = $i_sql . "from ema.bloques ";
            $i_sql = $i_sql . "where id_colonia=" . $id_proyecto . "; ";



            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}


	public function bb($objectid)
	{



			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[1] as campo1,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[2] as campo2,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[3] as campo3,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[4] as campo4";
			$i_sql = $i_sql. " from ( ";

			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.parcelas ";
            $i_sql = $i_sql . "where objectid=" . $objectid . " ";
            $i_sql = $i_sql . "group by objectid) as a) as t1 ";
            $i_sql = $i_sql . ";";
			//$i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}


	public function bblote($objectid)
	{
			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[1] as campo1,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[2] as campo2,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[3] as campo3,";
			$i_sql = $i_sql. "(regexp_split_to_array(bb, E','))[4] as campo4";
			$i_sql = $i_sql. " from ( ";
			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.lotes ";
            $i_sql = $i_sql . "where objectid=" . $objectid . " ";
            $i_sql = $i_sql . "group by objectid) as a) as t1 ";
            $i_sql = $i_sql . ";";
			//$i_sql = $i_sql . ") as x;";
            $response = $this->db->query($i_sql)->result_array();
            return $response;
	}


	public function bbaldea($objectid)
	{
			$i_sql = "select ";
			$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";
			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";	
			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.aldeas ";
            $i_sql = $i_sql . "where objectid=" . $objectid . " ";
            $i_sql = $i_sql . "group by objectid) as a) as t1 ";
            //$i_sql = $i_sql . ";";
			$i_sql = $i_sql . ") as x;";
            $response = $this->db->query($i_sql)->result_array();

            return $response;
	}



	public function bbbloque($objectid)
	{
			$i_sql = "select 
			round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, 
			round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, 
			round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, 
			round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 
			from 
			(
			select 
			cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,
			cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,
			cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,
			cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4 
			 from ( 
			select 
            replace(
            replace(substr(cast(a.bb as varchar),5),' ',',')  
            ,')','') as bb 
            FROM (select ST_Extent(the_geom) as bb 
            from i3geo.bloques 
            where objectid=" . $objectid . " 
            group by objectid) as a) as t1             
			) as x;";


            $response = $this->db->query($i_sql)->result_array();

            return $response;
	}


	public function mapabb($objectid)
	{


			$i_sql = "select ";
			$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";

			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";
				
			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.parcelas ";
            $i_sql = $i_sql . "where objectid=" . $objectid . " ";
            $i_sql = $i_sql . "group by objectid) as a) as t1 ";
            //$i_sql = $i_sql . ";";
			$i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}

	public function mapabb_lote($lote_n)
	{

			$i_sql = "select ";
			$i_sql = $i_sql."cast(round(cast((x.campo1-(x.campo3-x.campo1)/10) as decimal),13) as text) as ext1, ";
			$i_sql = $i_sql."cast(round(cast((x.campo2-(x.campo4-x.campo2)/10) as decimal),13) as text) as ext2, ";
			$i_sql = $i_sql."cast(round(cast((x.campo3+(x.campo3-x.campo1)/10) as decimal),13) as text) as ext3, ";
			$i_sql = $i_sql."cast(round(cast((x.campo4+(x.campo4-x.campo2)/10) as decimal),13) as text) as ext4 ";
			//$i_sql = "select ";
			//$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			//$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			//$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			//$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";

			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";
				
			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
			$i_sql = $i_sql."from ";
			$i_sql = $i_sql."(select ST_Extent(the_geom) bb from ";
			$i_sql = $i_sql."(select 1 objectid, st_union(st_snaptogrid(the_geom,0.00000000000001)) the_geom ";
		    $i_sql = $i_sql."from i3geo.parcelas t ";
            //$i_sql = $i_sql."where t.lote_n='".$lote_n."' and ST_IsValid(the_geom)) e ";
            $i_sql = $i_sql."where t.lote_n='".$lote_n."' ) e ";
	        $i_sql = $i_sql.") as a) as t1) as x;  ";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}

	public function mapafincabb($objectid)
	{

		$sq = "select  ";
		$sq = $sq."round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
		$sq = $sq."round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
		$sq = $sq."round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, "; 
		$sq = $sq."round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 "; 
		$sq = $sq."from "; 
		$sq = $sq."( ";
		$sq = $sq."select "; 
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4 "; 
		$sq = $sq."from ( ";						
		$sq = $sq."select "; 
		$sq = $sq."replace( ";
		$sq = $sq."replace(substr(cast(a.bb as varchar),5),' ',','),')','') as bb "; 
		$sq = $sq."FROM (select ST_Extent(st_makevalid(u.the_geom)) as bb "; 
		$sq = $sq."from (select 1 objectid, st_union(st_snaptogrid(f.the_geom,0.00000000000001)) the_geom  ";
		$sq = $sq."from i3geo.v_fincas f where f.objectid_p=".$objectid." ) u ";
		$sq = $sq.") as a) as t1 ) as x; ";

        $response = $this->db->query($sq)->result_array();

        return $response;

	}

	public function mapafincabb_lote($lote_n)
	{

		$sq = "select  ";
		$sq = $sq."round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
		$sq = $sq."round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
		$sq = $sq."round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, "; 
		$sq = $sq."round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 "; 
		$sq = $sq."from "; 
		$sq = $sq."( ";
		$sq = $sq."select "; 
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3, ";
		$sq = $sq."cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4 "; 
		$sq = $sq."from ( ";						
		$sq = $sq."select "; 
		$sq = $sq."replace( ";
		$sq = $sq."replace(substr(cast(a.bb as varchar),5),' ',','),')','') as bb "; 
		$sq = $sq."FROM (select ST_Extent(u.the_geom) as bb "; 
		$sq = $sq."from (select 1 objectid, st_union(st_snaptogrid(st_makevalid(f.the_geom),0.00000000000001)) the_geom  ";
		$sq = $sq."from i3geo.v_fincas f where f.lote_n='".$lote_n."' ) u ";
		$sq = $sq.") as a) as t1 ) as x; ";

        $response = $this->db->query($sq)->result_array();

        return $response;

	}

}