<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pga_model extends CI_Model {

    public function get_all($filters = [], $limit = 10, $offset = 0)
    {
        if (!empty($filters['id'])) {
            $this->db->where('id', $filters['id']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        if (!empty($filters['id_proyecto'])) {
            $this->db->where('id_proyecto', $filters['id_proyecto']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        if (!empty($filters['nombre_proyecto'])) {
            $this->db->where('nombre_proyecto', $filters['nombre_proyecto']); // Asumo que es numérico, por lo que no necesita ajuste.
        }        
        if (!empty($filters['tipo_riesgo'])) {
            $this->db->like('LOWER(tipo_riesgo)', strtolower($filters['tipo_riesgo']));
        }
        if (!empty($filters['tipo_plan'])) {
            $this->db->like('LOWER(tipo_plan)', strtolower($filters['tipo_plan']));
        }
        if (!empty($filters['estado'])) {
            $this->db->like('LOWER(estado)', strtolower($filters['estado']));
        }
        if (!empty($filters['des_tipo_riesgo'])) {
            $this->db->like('LOWER(des_tipo_riesgo)', strtolower($filters['des_tipo_riesgo']));
        }
        if (!empty($filters['des_tipo_plan'])) {
            $this->db->like('LOWER(des_tipo_plan)', strtolower($filters['des_tipo_plan']));
        }
        if (!empty($filters['des_pga_estado'])) {
            $this->db->like('LOWER(des_pga_estado)', strtolower($filters['des_pga_estado']));
        }

        return $this->db->get('ema.v_pga_index', $limit, $offset)->result();
    }

    public function count_pgas($filters) {
       if (!empty($filters['id'])) {
            $this->db->where('id', $filters['id']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        if (!empty($filters['id_proyecto'])) {
            $this->db->where('id_proyecto', $filters['id_proyecto']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        if (!empty($filters['nombre_proyecto'])) {
            $this->db->where('nombre_proyecto', $filters['nombre_proyecto']); // Asumo que es numérico, por lo que no necesita ajuste.
        }  
        if (!empty($filters['tipo_riesgo'])) {
            $this->db->like('tipo_riesgo', $filters['tipo_riesgo']);
        }
        if (!empty($filters['tipo_plan'])) {
            $this->db->like('tipo_plan', $filters['tipo_plan']);
        }
        if (!empty($filters['estado'])) {
            $this->db->like('LOWER(estado)', strtolower($filters['estado']));
        }
        if (!empty($filters['des_tipo_riesgo'])) {
            $this->db->like('LOWER(des_tipo_riesgo)', strtolower($filters['des_tipo_riesgo']));
        }
        if (!empty($filters['des_tipo_plan'])) {
            $this->db->like('LOWER(des_tipo_plan)', strtolower($filters['des_tipo_plan']));
        }
        if (!empty($filters['des_pga_estado'])) {
            $this->db->where('LOWER(des_pga_estado)', strtolower($filters['des_pga_estado']));
        }
        return $this->db->count_all_results('ema.v_pga_index'); // Cuenta los registros en la tabla 'pgas'
    }
    

    public function insert($data) {
        $this->db->insert('ema.pga', $data);
        return $this->db->insert_id(); // Retorna el ID del PGA recién creado
    }

    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('ema.pga', $data);
    }

    public function delete($id) {
        $this->db->where('id', $id);
        return $this->db->delete('ema.pga');
    }

    public function concepto($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }

    public function get_proyecto_nombre($id_proyecto) {
        $this->db->select('nombre');
        $this->db->from('ema.proyectos');
        $this->db->where('gid', $id_proyecto);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->nombre;
        }
        return null;
    }
}
