<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('man_espacial/proyectos/proyectos_model');
		$this->lang->load('proyectos/proyectos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		/*
		if ($_SESSION['id_modulo'] != 'proyectos') {

			$_SESSION['arraywhere_proyectos'] 		 = NULL;
			$_SESSION['arraywhere_proyectos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'proyectos';
		} 
		*/  
		
		// Breadcrumbs :: Common //
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'man_espacial/proyectos/proyectos');
	}

	public function colonia_mantenimiento($gid)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'man_espacial/proyectos/proyectos');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $col_datos = $this->proyectos_model->view('v_proyectos_index', array('gid' => $gid))->row();

	        //$dpto_cod = $col_datos->dpto;
	        //$dist_cod = $col_datos->distrito;

	        $col_cod = $col_datos->col_cod;
	        $nombre = utf8_decode($col_datos->nombre);
	        $estado = $col_datos->estado;

			$col_info  = $this->proyectos_model->view('v_proyectos_index', array('gid' => $gid))->result_array();

			/************* CANTIDAD DATOS GRAFICOS ****************/
			///$datos_graficos[0]['SIRT_PARCELAS']		= $this->proyectos_model->contador_registros('in_temp', array('dpto' => $dpto_cod, 'distrito' => $dist_cod, 'colonia' => $col_cod));

			$this->data['col_info'] 		= $col_info;
 
			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['url_mapserver']   = $_SESSION['url_mapserver'];


			$this->data['gid'] = array(
				'type'     => 'hidden',
				'name'     => 'gid',
				'id'       => 'gid',
				'value'    => $gid
			);

			
			//$this->data['dpto_cod'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'dpto_cod',
			//	'id'       => 'dpto_cod',
			//	'value'    => $dpto_cod
			//);

			//$this->data['dist_cod'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'dist_cod',
			//	'id'       => 'dist_cod',
			//	'value'    => $dist_cod
			//);

			$this->data['col_cod'] = array(
				'type'     => 'hidden',
				'name'     => 'col_cod',
				'id'       => 'col_cod',
				'value'    => $col_cod
			);

			$this->data['nombre'] = array(
				'type'     => 'hidden',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $nombre
			);

			$this->data['estado'] = array(
				'type'     => 'hidden',
				'name'     => 'estado',
				'id'       => 'estado',
				'value'    => $estado
			);
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('man_espacial/proyectos/Mantenimiento', $this->data);
		}
	}

	public function mantenimiento_colmen($gid = NULL)
	{

		if ( $gid == NULL)
		{
			redirect('man_espacial/proyectos/proyectos', 'refresh');
		}
	
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'man_espacial/proyectos/proyectos');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			//  proyectos //
	        $col_datos = $this->proyectos_model->view('v_proyectos_index', array('gid' => $gid))->row();
	        //$dpto_cod = $col_datos->dpto_cod;
	        //$dist_cod = $col_datos->dist_cod;
	        $col_cod = $col_datos->col_cod;
	        //$nombre = utf8_decode($col_datos->nombre);
	        $estado = $col_datos->estado;
			$col_info  = $this->proyectos_model->view('v_proyectos_index', array('gid' => $gid))->result_array();
			//  proyectos //

	        //$this->data['breadcrumb'] = $this->breadcrumbs->show();

	        //$exp_datos = $this->proyectos_model->view('exp', array('expe_id' => $gid))->row();

			$u_alter  = $this->proyectos_model->dropdown_data('v_resumen_uso_alter', array('id_colonia' => $gid), 'id_colonia, uso')->result_array();

			$u_actual = $this->proyectos_model->dropdown_data('v_resumen_uso_actual', array('id_colonia' => $gid), 'id_colonia, uso')->result_array();

			$u_1986   = $this->proyectos_model->dropdown_data('v_resumen_uso86', array('id_colonia' => $gid), 'id_colonia, uso')->result_array();

	        //$expe_id_expediente = $exp_datos->expe_id_expediente;
	        //$expe_gestion		= $exp_datos->expe_gestion;

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";

			//$expe_info  = $this->proyectos_model->view('exp', array('expe_id' => $gid))->result_array();

			$id_epsg = 32721;
	        if (isset($_POST) && ! empty($_POST)) {
                $arraywhere = null;
                if ($_POST['id_epsg'] ) {
                    $id_epsg = $_POST['id_epsg'];
                } else {
					$id_epsg = 32721;
                }
	        }

			//$expe_info[0]["expe_tipo_ref_desc"] = $this->proyectos_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]));

			$expe_info[0]["expe_estado_desc"]='';

			/*--------------- CANTIDAD DATOS GRAFICOS --------------------*/

			$datos_graficos[0]['uso86']		      = $this->proyectos_model->contador_registros('uso86',array('id_colonia' => $gid)); 		
			$datos_graficos[0]['uso_actual']	  = $this->proyectos_model->contador_registros('uso_actual',array('id_colonia' => $gid)); 	

			$datos_graficos[0]['uso_alternativo'] = $this->proyectos_model->contador_registros('uso_alternativo',array('id_colonia' => $gid));

			$datos_graficos[0]['fincas']		  = $this->proyectos_model->contador_registros('fincas',array('id_colonia' => $gid)); 			
			$datos_graficos[0]['parcelas']		  = $this->proyectos_model->contador_registros('parcelas',array('id_colonia' => $gid)); 	
			$datos_graficos[0]['capacidad']		  = $this->proyectos_model->contador_registros('capacidad',array('id_colonia' => $gid)); 	
			$datos_graficos[0]['taxonomia']		  = $this->proyectos_model->contador_registros('taxonomia',array('id_colonia' => $gid)); 	 	
			$datos_graficos[0]['bloques']		  = $this->proyectos_model->contador_registros('bloques',array('id_colonia' => $gid));

			$datos_graficos[0]['lotes']		  = $this->proyectos_model->contador_registros('lotes',array('id_colonia' => $gid)); 

			$datos_graficos[0]['poligono_proyecto']		  = $this->proyectos_model->contador_registros('poligono_proyecto',array('id_proyecto' => $gid)); 

			$datos_graficos[0]['unidad_productiva']		  = $this->proyectos_model->contador_registros('unidad_productiva',array('id_proyecto' => $gid)); 	

			$datos_graficos[0]['plano_proyecto']		  = $this->proyectos_model->contador_registros('plano_proyecto',array('id_proyecto' => $gid)); 

			$datos_graficos[0]['coordenadas']		  = $this->proyectos_model->contador_registros('coordenadas',array('id_proyecto' => $gid)); 			



			$datos_graficos[0]['id_tabla_imp'] = '';
			$datos_graficos[0]['id_tabla_del'] = '';

			/*---------------- FIN CANTIDAD DATOS GRAFICOS ---------------*/

			//$this->data['expe_info'] 		= $expe_info;

			$this->data['u_alter'] 			= $u_alter;
			$this->data['u_actual'] 		= $u_actual;
			$this->data['u_1986'] 			= $u_1986;

			$this->data['datos_graficos'] 	= $datos_graficos;

			// proyectos //
			$this->data['col_info'] 		= $col_info;
			$this->data['datos_graficos'] 	= $datos_graficos;
			$this->data['url_mapserver']   = $_SESSION['url_mapserver'];
			// proyectos //
			//$this->data['expe_id_expediente'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'expe_id_expediente',
			//	'id'       => 'expe_id_expediente',
			//	'value'    => $expe_id_expediente
			//);

			//$this->data['expe_gestion'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'expe_gestion',
			//	'id'       => 'expe_gestion',
			//	'value'    => $expe_gestion
			//);

			$this->data['expe_id'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id',
				'id'       => 'expe_id',
				'value'    => $gid
			);

			// proyectos //
			$this->data['gid'] = array(
				'type'     => 'hidden',
				'name'     => 'gid',
				'id'       => 'gid',
				'value'    => $gid
			);

			//$this->data['dpto_cod'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'dpto_cod',
			//	'id'       => 'dpto_cod',
			//	'value'    => $dpto_cod
			//);

			//$this->data['dist_cod'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'dist_cod',
			//	'id'       => 'dist_cod',
			//	'value'    => $dist_cod
			//);

			$this->data['col_cod'] = array(
				'type'     => 'hidden',
				'name'     => 'col_cod',
				'id'       => 'col_cod',
				'value'    => $col_cod
			);

			//$this->data['nombre'] = array(
			//	'type'     => 'hidden',
			//	'name'     => 'nombre',
			//	'id'       => 'nombre',
			//	'value'    => $nombre
			//);

			$this->data['estado'] = array(
				'type'     => 'hidden',
				'name'     => 'estado',
				'id'       => 'estado',
				'value'    => $estado
			);

			$this->data['id_epsg'] = $id_epsg;

            $t_epsgs[''] = 'Seleccione el EPSG';
            $t_epsg = $this->proyectos_model->dropdown_data('t_epsgs')->result_array();
            foreach ($t_epsg as $item) {
                $t_epsgs[$item['id_epsg']] = $item['t_epsg'];
            }
            $this->data['t_epsg'] = $t_epsgs;
            $this->data['t_epsg_sel'] = $id_epsg;
			// proyectos //
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('man_espacial/proyectos/mantenimiento_colmen', $this->data);
		}
	}

	public function download_lotescol($dpto = NULL, $distrito = NULL, $colonia = NULL, $gid= NULL)
	{
  		//$colonia['dpto_cod'].'/'.$colonia['dist_cod'] .'/'.$colonia['col_cod'] .'/'.$colonia['gid'] 
		if ($_SESSION['tipo_plataforma'] === 'produccion') {
        	exec('cmd /c "C:\dir_ema\exp_lotes_tabla_a_shp.bat postgres Elefante2024i7 '.trim($gid).'"');	
        }
        else {
        	exec('cmd /c "C:\dir_ema\exp_lotes_tabla_a_shp.bat postgres Elefante2024i7 '.trim($gid).'"');	
        }
        $download_file = "colonia".$gid.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$_POST['gid']);
	}



	public function download_colmen($gid = NULL)
	{
	
        exec('cmd /c "C:\dir_ema\ema_exp_tablas_a_shp.bat postgres Elefante2024i7 '.trim($gid).'"');	

        //ver descripción

        //$variable = get_current_user();

        //echo 'usuario: '.$variable;
		//show_error('TEMPORALMENTE INACTIVO');		

        $download_file = "ema_files".$gid.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);

	}



	public function gen_exp_polilineas($dpto = NULL, $distrito = NULL, $colonia = NULL, $gid= NULL)
	{

  		//$colonia['dpto_cod'].'/'.$colonia['dist_cod'] .'/'.$colonia['col_cod'] .'/'.$colonia['gid'] 

		$tabla = 'in_temp';

		$existe_colonia = $this->proyectos_model->contador_registros($tabla, array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));

		if ($existe_colonia == 0) {
			$resul = 'NO';
		}else{
			$resultado = $this->proyectos_model->md_generar_lineas($dpto, $distrito, $colonia);
			if ($resultado == TRUE) {
				$resul = 'SI';
			}else{
				$resul = 'NO';
			}											
		}  		

		if ($resul == 'SI') {
			if ($_SESSION['tipo_plataforma'] == 'produccion') {
	        	exec('cmd /c "C:\dir_ema\exp_polilineas_tabla_a_shp.bat postgres Elefante2024i7 '.trim($gid).'"');	
	        }
	        else {
	        	exec('cmd /c "C:\dir_ema\exp_polilineas_tabla_a_shp.bat postgres Elefante2024i7 '.trim($gid).'"');	
	        }
	        $download_file = "polilineas".$gid.".zip";

			if ( ! empty($download_file)) {
	        	//If you want to download an existing file from your server you'll need to read the file into a string
	        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
	        	$name = $download_file;
	        	force_download($name, $data);
	        	$this->session->set_flashdata('message', 'Se exportaron las polilineas respectivas.');
	        }	
	        else {
	        	$this->session->set_flashdata('message', 'Hubo error en el proceso.');
	        }	    		    	
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		}	
	    else {
	    	$this->session->set_flashdata('message', 'No se exportaron polilineas, No existen parcelas o no se genero pericias.');
	    }

	}

	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$_POST['gid']);
		}

	    $dpto_cod = $_POST['dpto_cod'];
	    $dist_cod = $_POST['dist_cod'];
	    $col_cod = $_POST['col_cod'];
	    $gid = $_POST['gid'];
	    $estado = $_POST['estado'];

    	if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['id_tabla_imp'] ) {
                $arraycampos['id_tabla_imp'] = $_POST['id_tabla_imp'];
                $arraywhere['id_tabla_imp'] = $_POST['id_tabla_imp'];
            } else {
                $arraycampos['id_tabla_imp'] = '';
                $arraywhere['id_tabla_imp'] = '';
            }
        }

		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		

		// pregunta sin existen datos graficos del expediente.

		$Cant_parcelas = $this->proyectos_model->contador_registros('in_temp', array('dpto' => $dpto_cod, 'distrito' => $dist_cod, 'colonia' => $col_cod));

		//$expe = $this->proyectos_model->existe_grafico_gid($gid)->row()->f_existe_grafico;

		if ($Cant_parcelas>0) {
			$this->session->set_flashdata('message', 'COLONIA YA TIENE DATOS ESPACIALES!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$_POST['gid']);
		}
		else { 		
			if ($_SESSION['tipo_plataforma'] == 'produccion') {
				exec('cmd /c "'.trim('md C:\dir_ema\ ').trim($gid).'"');		
				$ruta_dest = trim('C:\dir_ema\ ').trim($gid).trim('\ ');
			}
			else {
				exec('cmd /c "'.trim('md C:\dir_ema\ ').trim($gid).'"');	
				$ruta_dest = trim('C:\dir_ema\ ').trim($gid).trim('\ ');	
			}
			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');			
			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;		
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;
					
					default:
						$i = $i + 1;
						break;			
				}
			}				

			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) { 	
				$id_epsg = 32720;
			} elseif ($accion == 3) { 	
				$id_epsg = 4326;
			} else  { 	
				$id_epsg = 32721;
			}

			// NOTA MUY IMPORTANTE imp_shp_a_tabla.bat se necesita lo siguiente:
			// Para poder ejecutar el 
			// En el archivo de seguridad de postgres C:\Program Files\PostgreSQL\9.3\data\pg_hba.conf
			// Dar autorizacion al ip de servidor con trust 
			// host    all             all             192.168.2.2/32          trust
			// host    all             all             127.0.0.1/32            trust
			// crear archivo de texto pgpass.conf
			// C:\Users\Usuario\AppData\Roaming\postgresql\pgpass.conf
			// con el contenido:
			// 192.168.1.131:5433:*:postgres:postgres //en pgpass.conf
            // 192.168.1.254:5433:*:postgres:postgres //en pgpass.conf
            ///////////////////////////////////////////////////////////////////////////////////////////
            // PENDIENTE: Es necesario enviar el ip servior respectivo el puerto 
            // una ves que se tenga la tabla de configuraciòn o un xml de configuracion.
			if ($_SESSION['tipo_plataforma'] == 'produccion') {
				exec('cmd /c "C:\dir_ema\imp_lotes_shp_a_tabla.bat '.trim($gid).' '.$id_epsg.'"'); 
			}
			else {
				exec('cmd /c "C:\dir_ema\imp_lotes_shp_a_tabla.bat '.trim($gid).' '.$id_epsg.'"'); 
			}
			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');
		    $dpto_cod = $_POST['dpto_cod'];
		    $dist_cod = $_POST['dist_cod'];
	    	$col_cod = $_POST['col_cod'];			
	    	$estado = $_POST['estado'];	


			$actu = $this->proyectos_model->validar_shapes($gid, $dpto_cod, $dist_cod, $col_cod, $id_epsg)->row()->actualizar_shapes;

			if ($actu>0) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen'.$_POST['gid']);
			}
			else { 	
				$actu = $this->proyectos_model->crear_poligono_colonia($dpto_cod, $dist_cod, $col_cod);
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> ');		

				redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$_POST['gid']);

			}
		}
	}



	public function importar_shapes_colmen()
	{

		//$id_expediente 	= $_POST['expe_id_expediente'];
		//$gestion 		= $_POST['expe_gestion'];
		//$expe_id 		= $_POST['expe_id'];

	    //$dpto_cod 	= $_POST['dpto_cod'];
	    //$dist_cod 	= $_POST['dist_cod'];
	    $col_cod 	= $_POST['col_cod'];
	    $gid 		= $_POST['gid'];
	    $estado 	= $_POST['estado'];

		
		//echo('gid:');
		//echo($gid);
		//show_error(1);
		

		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}

		$id_epsg = 32721;	
		if (isset($_POST['id_epsg'])){
			$id_epsg = intval($_POST['id_epsg']);
		}else{
			$id_epsg = 32721;
		}

		/*
        uso86     
        uso_actual
		uso_alternativo
        fincas
        parcelas
        capacidad 
        taxonomia
        */
        /*
		if ($i == 0) {
		    echo "i es igual a 0";
		} elseif ($i == 1) {
		    echo "i es igual a 1";
		} elseif ($i == 2) {
		    echo "i es igual a 2";
		}
		*/

		switch ($accion) {
		    case 20:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('uso86',$gid);
				$TABLA ='uso86';
		        break;
		    case 21:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('uso_actual',$gid);	
				$TABLA ='uso_actual';	
		        break;
		    case 22:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('uso_alternativo',$gid);		
				$TABLA ='uso_alternativo';			        
				break;
		    case 23:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('fincas',$gid);	
				$TABLA ='fincas';
		        break;
		    case 24:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('coordenadas',$gid);
				$TABLA ='coordenadas';
		        br4ak;
		    case 25:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('capacidad',$gid);
				$TABLA ='capacidad';
		        break;
		    case 26:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('taxonomia',$gid);
				$TABLA ='taxonomia';
		        break;
		    case 27:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('poligono_proyecto',$gid);
				$TABLA ='poligono_proyecto';
		        break;
		    case 28:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('plano_proyecto',$gid);
				$TABLA ='plano_proyecto';
		        break;
		    case 29:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('unidad_productiva',$gid);
				$TABLA ='unidad_productiva';
		        break;
		    case 30:
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('todas',$gid);
				$TABLA ='todas';
		        break;	        
		}

		if ( $accion >= 20 and $accion < 70) {
			$this->session->set_flashdata('message', '¡SE ELIMINO DATOS DE LA TABLA!'.$TABLA);
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$gid);
		}

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$gid);
		}		

		$expe_id=1;
         
 		$resultado=0;

		switch ($accion) {
			case 10:
				$resultado = $this->proyectos_model->contador_registros('uso86',array('id_colonia' => $gid));
				$TABLA ='USO86';
				break;
			case 11:
				$resultado = $this->proyectos_model->contador_registros('uso_actual',array('id_colonia' => $gid));				
				$TABLA ='USO_ACTUAL';
				break;
			case 12:
				$resultado = $this->proyectos_model->contador_registros('uso_alternativo',array('id_colonia' => $gid));			
				$TABLA ='USO_ALTERNATIVO';
				break;
			case 13:
				$resultado = $this->proyectos_model->contador_registros('fincas',array('id_colonia' => $gid));	
				$TABLA ='FINCAS';
				break;
			case 14:
				$resultado = $this->proyectos_model->contador_registros('coordenadas',array('id_proyecto' => $gid));	
				$TABLA ='COORDENADAS';
				break;
			case 15:
				$resultado = $this->proyectos_model->contador_registros('capacidad',array('id_colonia' => $gid));	
				$TABLA ='CAPACIDAD';
				break;
			case 16:
				$resultado = $this->proyectos_model->contador_registros('taxonomia',array('id_colonia' => $gid));
				$TABLA ='TAXONOMIA';
				break;
			case 17:
				$resultado = $this->proyectos_model->contador_registros('poligono_proyecto',array('id_proyecto' => $gid));
				$TABLA ='POLIGONO_PROYECTO';
				break;
			case 18:
				$resultado = $this->proyectos_model->contador_registros('plano_proyecto',array('id_proyecto' => $gid));
				$TABLA ='PLANO_PROYECTO';
				break;
			case 19:
				$resultado = $this->proyectos_model->contador_registros('unidad_productiva',array('id_proyecto' => $gid));
				$TABLA ='UNIDAD_PRODUCTUVA';
				break;
			case 70:
				$resultado =  $this->proyectos_model->cnt_col_reg_layers($gid);
				$TABLA ='todas';
				break;				
		}								

		$expe_id=1;


		if ($resultado > 0) {
			$this->session->set_flashdata('message', 'LA TABLA '.$TABLA.' TIENE DATOS!');
			//echo($TABLA);
			//show_error(1);
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$gid);
		}
		else { 		
			//$expe_id=1;

        	//  FORMATO WINDOWS
        	 
			//exec('cmd /c "'.trim('rd /Q/S C:\dir_ema\ ').trim($gid).'"');
			//exec('cmd /c "'.trim('md C:\dir_ema\ ').trim($gid).'"');	
			//$ruta_dest = trim('C:\dir_ema\ ').trim($gid).trim('\ ');

        
        	//  FORMATO LINUX
			exec('rm -R /dir_ema/proyectos/proyecto'.trim($gid));
     		exec(trim('mkdir /dir_ema/proyectos/proyecto ').trim($gid));
			exec(trim('chmod 777 /dir_ema/proyectos/proyecto ').trim($gid));
			exec(trim('chmod 777 /dir_ema/proyectos/proyecto ').trim($gid).'/*');
			$ruta_dest = trim('/dir_ema/proyectos/proyecto ').trim($gid).trim('/ ');				

			//echo 'gid: '.$gid;
			//show_error('TEMPORALMENTE INACTIVO');


			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;		
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;
					
					default:
						$i = $i + 1;
						break;			

				}
			}				

			
			//echo 'TABLA: '.$TABLA;
			//show_error('TEMPORALMENTE INACTIVO');

			if ($TABLA == 'todas') {
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('todas',$gid);

				//  WINDOWS
            	//exec('cmd /c "C:\dir_ema\ema_imp_todas_a_tabla.bat '.$gid.' '.$id_epsg.'"');	            
            	
            	//LINUX
        		exec('/dir_ema/ema_imp_todas_a_tabla.sh '.trim($gid).' '.$id_epsg);

				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso_actual',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso_alternativo',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso86',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso_alternativo',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso86',$gid,$id_epsg);				
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('poligono_proyecto',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('unidad_productiva',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('plano_proyecto',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('coordenadas',$gid,$id_epsg);	
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('capacidad',$gid,$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('taxonomia',$gid,$id_epsg);	
				$resultado =  $this->proyectos_model->cnt_col_reg_layers($gid);
			} elseif ($TABLA == 'taxonomia') {
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('taxonomia',$gid);
				//exec('cmd /c "C:\dir_ema\ema_imp_shp_a_tabla.bat '.'tipo_suelo'.' '.$gid.' '.$id_epsg.'"');			
                exec('/dir_ema/ema_imp_shp_a_tabla.sh '.'tipo_suelo'.' '.trim($gid).' '.$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('taxonomia',$gid,$id_epsg);			
			    $resultado = $this->proyectos_model->contador_registros('taxonomia',array('id_colonia' => $gid));
			} elseif ($TABLA == 'capacidad') {
				$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('capacidad',$gid);
				//exec('cmd /c "C:\dir_ema\ema_imp_shp_a_tabla.bat '.'capacidad_aptitud'.' '.$gid.' '.$id_epsg.'"');	
            	exec('/dir_ema/ema_imp_shp_a_tabla.sh '.'capacidad_aptitud'.' '.trim($gid).' '.$id_epsg);            
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('capacidad',$gid,$id_epsg);			
				$resultado = $this->proyectos_model->contador_registros('capacidad',array('id_colonia' => $gid));
			//} elseif ($TABLA == 'uso86') {
			//	$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia('uso86',$gid);
			//	exec('cmd /c "C:\dir_ema\ema_imp_shp_a_tabla.bat '.'capacidad_aptitud'.' '.$gid.' '.$id_epsg.'"');			
			//	$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla('uso86',$gid,$id_epsg);			
			//	$resultado = $this->proyectos_model->contador_registros('uso86',array('id_colonia' => $gid));
			} else {
	        	$resultado = $this->proyectos_model->eliminar_datos_tabla_colonia(mb_strtolower($TABLA, 'UTF-8'),$gid);
				//exec('cmd /c "C:\dir_ema\ema_imp_shp_a_tabla.bat '.trim($TABLA).' '.$gid.' '.$id_epsg.'"');		
            	exec('/dir_ema/ema_imp_shp_a_tabla.sh '.trim($TABLA).' '.trim($gid).' '.$id_epsg);
				$actu = $this->proyectos_model->dinamic_copiar_temporal_a_tabla(mb_strtolower($TABLA, 'UTF-8'),$gid,$id_epsg);
				if (strtolower($TABLA) == 'poligono_proyecto' or strtolower($TABLA) == 'unidad_productiva' or strtolower($TABLA) == 'plano_proyecto' or strtolower($TABLA) == 'coordenadas' ) {
				    $resultado = $this->proyectos_model->contador_registros(mb_strtolower($TABLA, 'UTF-8'),array('id_proyecto' => $gid));
	            } else {
	                $resultado = $this->proyectos_model->contador_registros(mb_strtolower($TABLA, 'UTF-8'),array('id_colonia' => $gid));
	            }				
			}			

			if ($resultado > 0) {
				$this->session->set_flashdata('message', '¡IMPORTADOS!');		
				redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$gid);
			} else {
				$this->session->set_flashdata('message', 'NO importo!! Error en datos!!');
				redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$gid);
			}

		}
	}



	public function verparcela ($expe_id , $expe_gest) {
	
        	$i_jameuge = "http://201.217.59.143:8065/seampg/index.html?exp=" . $expe_id;
        	$i_jameuge = $i_jameuge . "&gest=" . $expe_gest;

			redirect($i_jameuge);
	}


	public function vercolonia ($dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL, $gid = NULL) {
	
		$bbox = $this->in_temp_model->colonia_bb($gid);
		if ($bbox)
		{
			$data['campo1'] = $bbox[0]['campo1'];
        	$data['campo2'] = $bbox[0]['campo2'];
        	$data['campo3'] = $bbox[0]['campo3'];
        	$data['campo4'] = $bbox[0]['campo4'];

        	$data['concat'] = $bbox[0]['campo1']. ',' . $bbox[0]['campo2'] . ',' .$bbox[0]['campo3']. ',' . $bbox[0]['campo4'];
			
        	$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ms_criamapa.php?layers=colonia";
        	$i_jameuge = $i_jameuge . "&map_layer_colonia_filter=gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	//$i_jameuge = $i_jameuge . "&hoja="."1";

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generar_lotes($i_colonia = NULL)
	{	

		$resultado = $this->proyectos_model->generar_lotes($i_colonia);

		$cantidad_registros = $this->proyectos_model->contador_registros('lotes_uso86', array('id_colonia' => $i_colonia));
		if ($cantidad_registros == 0) {
			$this->session->set_flashdata('message', 'No se generaron usos alternativos para esta cooperativa!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}				
		else {
			$this->session->set_flashdata('message', 'Se generaron usos alternativos para esta cooperativa: '.$cantidad_registros);
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}		
	}


	public function actualizar_categorias($i_colonia = NULL)
	{	
	

		$cantidad_registros = $this->proyectos_model->contador_registros('uso_alternativo', array('id_colonia' => $i_colonia));
		if ($cantidad_registros == 0) {
			$this->session->set_flashdata('message', 'No se cargaron usos alternativos para esta cooperativa!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}				
		else {
			$resultado = $this->proyectos_model->actualizar_categorias($i_colonia);
			$this->session->set_flashdata('message', 'Se actualizaron las categorias para esta cooperativa: '.$cantidad_registros);
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}		
	}


	public function actualizar_usos($i_colonia = NULL)
	{	
	

		$cantidad_registros = $this->proyectos_model->contador_registros('uso_alternativo', array('id_colonia' => $i_colonia));
		if ($cantidad_registros == 0) {
			$this->session->set_flashdata('message', 'No se cargaron usos alternativos para esta cooperativa!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}				
		else {

			$resultado = $this->proyectos_model->actualizar_usos('PARCELAS_USO_ALTERNATIVO',$i_colonia);
			$cantidad_registros = $this->proyectos_model->contador_registros('parcelas_uso_alternativo', array('id_colonia' => $i_colonia));
			$this->session->set_flashdata('message', 'Se actualizaron las categorias para PARCELAS_USO_ALTERNATIVO: '.$cantidad_registros);
			
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}		
	}

	public function actualizar_usos2($i_colonia = NULL)
	{	
	

		$cantidad_registros = $this->proyectos_model->contador_registros('uso_actual', array('id_colonia' => $i_colonia));
		if ($cantidad_registros == 0) {
			$this->session->set_flashdata('message', 'No se cargaron usos alternativos para esta cooperativa!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}				
		else {


			$resultado = $this->proyectos_model->actualizar_usos('PARCELAS_USO_ACTUAL',$i_colonia);
			$cantidad_registros = $this->proyectos_model->contador_registros('parcelas_uso_actual', array('id_colonia' => $i_colonia));
			$this->session->set_flashdata('message', 'Se actualizaron las categorias para PARCELAS_USO_ACTUAL: '.$cantidad_registros);

			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}		
	}

	public function actualizar_usos3($i_colonia = NULL)
	{	
	

		$cantidad_registros = $this->proyectos_model->contador_registros('uso86', array('id_colonia' => $i_colonia));
		if ($cantidad_registros == 0) {
			$this->session->set_flashdata('message', 'No se cargaron usos alternativos para esta cooperativa!');
			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}				
		else {

			$resultado = $this->proyectos_model->actualizar_usos('PARCELAS_USO86',$i_colonia);
			$cantidad_registros = $this->proyectos_model->contador_registros('parcelas_uso86', array('id_colonia' => $i_colonia));
			$this->session->set_flashdata('message', 'Se actualizaron las categorias para PARCELAS_USO86: '.$cantidad_registros);


			redirect('man_espacial/proyectos/mantenimiento/mantenimiento_colmen/'.$i_colonia);
		}		
	}


	public function eliminar_geometrias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{
		$existe_parcelas = $this->proyectos_model->contador_registros('in_temp', array('dpto' => $dpto_cod, 'distrito' => $dist_cod, 'colonia' => $col_cod));

		if ($existe_parcelas == 0) {

			$this->session->set_flashdata('message', 'No existen parcelas para esta colonia!');

			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		}				
		else {

			$resultado = $this->proyectos_model->eliminar_geometrias($gid,$dpto_cod,$dist_cod,$col_cod);

			$this->session->set_flashdata('message', 'Todas las parcelas fueron eliminadas!'.$resultado);
			
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);

		}		
 
		
	}

	public function validar_pericias($gid = NULL,$dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->validar_pericias($gid,$dpto_cod,$dist_cod,$col_cod);

		$this->session->set_flashdata('message', 'SE VALIDO LAS PERICIAS!');
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		
	}

	public function confirmar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->confirmar_pericias($gid,$dpto_cod,$dist_cod,$col_cod);

		$this->session->set_flashdata('message', 'SE CONFIRMO LAS PERICIAS!');
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		
	}


	public function actualizar_geometria($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->crear_poligono_colonia($gid,$dpto_cod,$dist_cod,$col_cod);

		$this->session->set_flashdata('message', 'SE ACTULIZO El poligobo de Colonia! ');
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		
	}

	public function habilitar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->habilitar_pericias($gid,$dpto_cod,$dist_cod,$col_cod);

		$this->session->set_flashdata('message', 'SE HABILITO LAS PERICIAS!');
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		
	}

	public function bloquear_planocolonia($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->bloquear_planocolonia($gid,$dpto_cod,$dist_cod,$col_cod);

		$this->session->set_flashdata('message', 'SE HABILITO LAS PERICIAS!');
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		
	}

	public function eliminar_periciaconfirmada($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->proyectos_model->eliminar_periciaconfirmada($gid,$dpto_cod,$dist_cod,$col_cod);

		//$this->session->set_flashdata('message', 'SE ELIMINO LAS PERICIAS CONFIRMADAS!');
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['message'] = $this->data['message'] . 'SE ELIMINO LAS PERICIAS CONFIRMADAS!' ;
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);		

/*
		if (isset($this->data['message'])) {
			
			$this->data['message'] = $this->data['message'] . 'SE ELIMINO LAS PERICIAS CONFIRMADAS!' ;
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);
		} else {	
			$this->data['message'] = $this->data['message'] . 'NO SE ELIMINO LAS PERICIAS CONFIRMADAS!' ;
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);

		}
			$this->data['message'] = $this->data['message'] . 'SE ELIMINO LAS PERICIAS CONFIRMADAS!' ;
			redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);		
*/
	}

	public function eliminar_in_parc($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL )
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');
			

			
                
		$resultado = $this->proyectos_model->eliminar_in_parc($gid,$dpto_cod,$dist_cod,$col_cod);

/*
			print_r($resultado);
			show_error(1);
*/
		//$this->session->set_flashdata('message', 'SE ELIMINO LAS PERICIAS CONFIRMADAS!');

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		$this->data['message'] = $this->data['message'] . 'SE ELIMINO LAS PARCELAS VALIDADAS!' ;
		redirect('man_espacial/proyectos/mantenimiento/colonia_mantenimiento/'.$gid);

	}






}