<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Grupos extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('grupos/Grupos_model');
        $this->lang->load('conceptos/conceptos');
        $this->load->library('pagination');
    }

    public function index() {
        $filters = [
            'id' => $this->input->get('id'),
            'id_cliente' => $this->input->get('id_cliente'),
            'nombre_cliente' => $this->input->get('nombre_cliente'), // ✅ Agregado
            'nombre_grupo' => $this->input->get('nombre_grupo')
        ];
    
        $user_id = $this->session->userdata('user_id');
        $tipo_usuario = $_SESSION['tipo_usuario'][0];
        $id_cliente = $_SESSION['id_cliente'][0];
    
        if ($tipo_usuario == 'C') {
            $filters['id_cliente'] = $id_cliente;
        }
    
        $config['base_url'] = site_url('grupos/grupos/index');
        $config['total_rows'] = $this->Grupos_model->count_grupos($filters);
        $config['per_page'] = 10;
    
        $this->pagination->initialize($config);
    
        $data['grupos'] = $this->Grupos_model->get_grupos($filters, $config['per_page'], $this->uri->segment(4));
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
    
        $this->template->admin_render('grupos/index', array_merge($data, $this->data));
    }
    

    public function create() {
        
        if ($this->input->post()) {
            $data = [
                'id_cliente' => $this->input->post('id_cliente'),
                'nombre_grupo' => $this->input->post('nombre_grupo')
            ];

            /* Cargar listado de clientes */
            
            $this->Grupos_model->insert_grupo($data);
            redirect('grupos/grupos');
        }

        $a_clientes[''] = 'Seleccione el Cliente';
        $d_clientes = $this->Grupos_model->dropdown_data('ema.cliente'); // Nombre completo de la tabla

        
        foreach ($d_clientes as $r_cliente) {
            $a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
        }

        $this->data['cliente'] = $a_clientes;
        
        //$this->load->view('grupos/create');
        $this->template->admin_render('grupos/create', $this->data);        
    }

    public function edit($id) {
    // Verifica si el grupo existe
    $data['grupo'] = $this->Grupos_model->get_grupo($id);
    if (!$data['grupo']) {
        show_error('El grupo no existe.', 404);
    }

    // Si se envía el formulario, actualiza los datos
    if ($this->input->post()) {
        $update_data = [
            'id_cliente' => $this->input->post('id_cliente'),
            'nombre_grupo' => $this->input->post('nombre_grupo')
        ];
        $this->Grupos_model->update_grupo($id, $update_data);
        redirect('grupos/grupos');
    }

    

    // Cargar la lista de clientes correctamente
    $a_clientes[''] = 'Seleccione el Cliente';
    $d_clientes = $this->Grupos_model->dropdown_data('ema.cliente'); // Asegúrate del nombre de la tabla

    foreach ($d_clientes as $r_cliente) {
        $a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
    }

    // Asignar datos a la vista
    $this->data['cliente'] = $a_clientes;
    $this->data['cliente_sel'] = $data['grupo']['id_cliente']; // Evita error de variable no definida
    $this->data['grupo'] = $data['grupo'];

    // Renderizar la vista
    $this->template->admin_render('grupos/edit', array_merge($this->data, $data));
}

public function view($id) 
    {
        // Verifica si el grupo existe
        $data['grupo'] = $this->Grupos_model->get_grupo($id);
        if (!$data['grupo']) {
            show_error('El grupo no existe.', 404);
        }

        // Si se envía el formulario, actualiza los datos
        if ($this->input->post()) {
            $update_data = [
                'id_cliente' => $this->input->post('id_cliente'),
                'nombre_grupo' => $this->input->post('nombre_grupo')
            ];
            $this->Grupos_model->update_grupo($id, $update_data);
            redirect('grupos/grupos');
        }

        

        // Cargar la lista de clientes correctamente
        $a_clientes[''] = 'Seleccione el Cliente';
        $d_clientes = $this->Grupos_model->dropdown_data('ema.cliente'); // Asegúrate del nombre de la tabla

        foreach ($d_clientes as $r_cliente) {
            $a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
        }

        // Asignar datos a la vista
        $this->data['cliente'] = $a_clientes;
        $this->data['cliente_sel'] = $data['grupo']['id_cliente']; // Evita error de variable no definida
        $this->data['grupo'] = $data['grupo'];

        // Renderizar la vista
        $this->template->admin_render('grupos/view', array_merge($this->data, $data));
    }

    public function delete($id) {
        $this->Grupos_model->delete_grupo($id);
        redirect('grupos/grupos');
    }
}