<?php
class Declaraciones extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Declaraciones_model');
        $this->load->helper('url');
    }

    public function index() {
        $filters = $this->input->get();
        $data['declaraciones'] = $this->Declaraciones_model->get_declaraciones($filters);
        //$this->load->view('declaraciones/index', $data);
        $this->template->admin_render('declaraciones/index', array_merge($data, $this->data));
    }

    public function create() {
        // Reglas de validación
        $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
        $this->form_validation->set_rules('nro_declaracion', 'Número de Declaración', 'required|numeric');
        $this->form_validation->set_rules('gestion_declaracion', 'Gestión', 'required|numeric');
        $this->form_validation->set_rules('estado', 'Estado', 'required');
        $this->form_validation->set_rules('fecha_declaracion', 'Fecha de Declaración', 'required');
        $this->form_validation->set_rules('fecha_declaracion_vto', 'Fecha de Vencimiento Declaración', 'required');
        $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento');
    
        if ($this->form_validation->run() === FALSE) {
            // Si falla la validación, carga la vista con los errores
            $this->template->admin_render('declaraciones/create', array_merge($this->data));
        } else {
            // Si pasa la validación, guarda la declaración
            $data = [
                'id_proyecto' => $this->input->post('id_proyecto'),
                'nro_declaracion' => $this->input->post('nro_declaracion'),
                'gestion_declaracion' => $this->input->post('gestion_declaracion'),
                'estado' => $this->input->post('estado'),
                'fecha_declaracion' => $this->input->post('fecha_declaracion'),
                'fecha_declaracion_vto' => $this->input->post('fecha_declaracion_vto'),
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa'),
                'observacion' => $this->input->post('observacion'),
            ];
    
            $this->Declaraciones_model->create_declaracion($data);
            redirect('declaraciones');
        }
    }
    

    // Editar una declaración existente
    public function edit($id) {
        $declaracion = $this->Declaraciones_model->get_declaraciones(['id_declaracion' => $id]);
        
        if (!$declaracion) {
            show_404();
        }

        // Reglas de validación
        $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
        $this->form_validation->set_rules('nro_declaracion', 'Número de Declaración', 'required|numeric');
        $this->form_validation->set_rules('gestion_declaracion', 'Gestión', 'required|numeric');
        $this->form_validation->set_rules('estado', 'Estado', 'required');
        $this->form_validation->set_rules('fecha_declaracion', 'Fecha de Declaración', 'required');
        $this->form_validation->set_rules('fecha_declaracion_vto', 'Fecha de Vencimiento Declaración', 'required');
        $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento');

        if ($this->form_validation->run() === FALSE) {
            // Si falla la validación, carga la vista con los datos actuales
            $data['declaracion'] = $declaracion;
            //$this->load->view('declaraciones/edit', $data);
            $this->template->admin_render('declaraciones/edit', array_merge($this->data));
        } else {
            // Si pasa la validación, actualiza la declaración
            /* $data = $this->input->post();
            $this->Declaraciones_model->update_declaracion($id, $data);
            redirect('declaraciones'); */
            $data['declaracion'] = $declaracion[0];
            //$this->load->view('declaraciones/edit', $data);
            $this->template->admin_render('declaraciones/edit', array_merge($this->data));
        }
    }

    public function delete($id) {
        $this->Declaraciones_model->delete_declaracion($id);
        redirect('declaraciones');
    }
}
