<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Resoluciones extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Resoluciones_model');
        $this->load->model('Tumba_model');
        $this->load->helper('url');
        $this->load->library('pagination');
    }

    public function index($id_proyecto = NULL)
    {
        // Obtener filtros desde GET
        $filters = $this->input->get();
        $filters['id_proyecto'] = $id_proyecto;  // Asegurar que el id_proyecto esté presente en los filtros
        
        // Configuración de la paginación
        $config['base_url'] = site_url('resoluciones/index/' . $id_proyecto . '?' . http_build_query($filters));
        $config['total_rows'] = $this->Resoluciones_model->count_resoluciones($filters);
        $config['per_page'] = 10;
        
        // Obtener lista de estados desde el modelo
        $estados = $this->Resoluciones_model->concepto('RESOL_ESTADO', false, 'CONCEPTO');
        
        // Crear el dropdown de estados
        $dropdown_estados = ['' => 'Seleccione un Estado'];  // Opción por defecto
        foreach ($estados as $estado) {
            // Se asigna el 'concepto' como valor y 'concepto - nombre' como texto visible
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }

        // Obtener lista de tipo_resoluciones desde el modelo
        $tipo_resoluciones = $this->Resoluciones_model->concepto('TIPO_RESOLUCIONES', false, 'CONCEPTO');
        
        // Crear el dropdown de tipo_resoluciones
        $dropdown_tipo_resoluciones = ['' => 'Seleccione un Tipo de Resolución'];  // Opción por defecto
        foreach ($tipo_resoluciones as $tipo_resolucion) {
            // Se asigna el 'concepto' como valor y 'concepto - nombre' como texto visible
            $dropdown_tipo_resoluciones[$tipo_resolucion['concepto']] = $tipo_resolucion['concepto'] . ' - ' . $tipo_resolucion['nombre'];
        }
        
        // Obtener nombre del proyecto
        $nombre_proyecto = $this->Resoluciones_model->get_proyecto_nombre($id_proyecto);
        
        // Inicializar la paginación
        $this->pagination->initialize($config);
        
        // Obtener las resoluciones con los filtros aplicados
        $data['resoluciones'] = $this->Resoluciones_model->get_resoluciones($filters, $config['per_page'], $this->uri->segment(4));
        
        // Generar los enlaces de paginación
        $data['pagination'] = $this->pagination->create_links();
        
        // Asignar los filtros y otros datos a la vista
        $data['filters'] = $filters;
        $data['id_proyecto'] = $id_proyecto;
        $data['nombre_proyecto'] = $nombre_proyecto;
        $data['dropdown_estados'] = $dropdown_estados;  // Pasar el dropdown de estados a la vista
        $data['dropdown_tipo_resoluciones'] = $dropdown_tipo_resoluciones;  // Pasar el dropdown de tipo_resoluciones a la vista
        
        // Renderizar la vista
        $this->template->admin_render('resoluciones/index', array_merge($data, $this->data));
    }

    public function create($id_proyecto = NULL)
    {
        // Verificar si el formulario fue enviado
        if ($this->input->post()) {
            $data = [
                'id_proyecto' => $this->input->post('id_proyecto'),
            ];
            $id_proyecto = $data['id_proyecto'];
        }
    
        // Inicializar la variable declaraciones antes de la validación
        $where = [];
        if (!empty($id_proyecto)) {
            $where['id_proyecto'] = $id_proyecto; // Agregar filtro por id_proyecto
        }

        // Obtener las declaraciones asociadas al proyecto
        $declaraciones = $this->Resoluciones_model->get_declaraciones_by_proyecto($id_proyecto);

        // Si se encontraron declaraciones, asignar el id_declaracion a la vista
        if (!empty($declaraciones)) {
            // Aquí puedes asignar el primer id_declaracion encontrado
            $id_declaracion = $declaraciones[0]['id_declaracion'];
        } else {
            $id_declaracion = ''; // Si no se encuentran declaraciones, asigna un valor vacío
        }

        // Pasar a la vista
        $this->data['id_declaracion'] = $id_declaracion; 
        $this->data['declaraciones'] = $declaraciones;
        
        // Obtener lista de estados desde el modelo
        $estados = $this->Resoluciones_model->concepto('RESOL_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['nombre']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
    
        $this->data['dropdown_estados'] = $dropdown_estados;
    
        // Obtener lista de tipo_resoluciones desde el modelo
        $tipo_resoluciones = $this->Resoluciones_model->concepto('TIPO_RESOLUCIONES', false, 'CONCEPTO');
        $dropdown_tipo_resoluciones = ['' => 'Seleccione un Tipo de Resolución']; // Opción por defecto
        foreach ($tipo_resoluciones as $tipo_resolucion) {
            $dropdown_tipo_resoluciones[$tipo_resolucion['concepto']] = $tipo_resolucion['concepto'] . ' - ' . $tipo_resolucion['nombre'];
        }
        $this->data['dropdown_tipo_resoluciones'] = $dropdown_tipo_resoluciones;
    
        // Reglas de validación
        $this->form_validation->set_rules('id_declaracion', 'ID Declaración', 'required|numeric');
        $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
        $this->form_validation->set_rules('nro_resolucion', 'Número de Resolución', 'required|numeric|max_length[6]');
        $this->form_validation->set_rules('gestion_resolucion', 'Gestión Resolución', 'required|numeric|max_length[4]');
        $this->form_validation->set_rules('fecha_resolucion', 'Fecha Resolución', 'required');
        $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento AA');
        $this->form_validation->set_rules('estado', 'Estado', 'required|in_list[A,I]');
        $this->form_validation->set_rules('observacion', 'Observación', 'max_length[10000]');
    
        // Ejecutar validación
        if ($this->form_validation->run() === FALSE) {
            // Si la validación falla, carga la vista con los errores
            $this->data['id_proyecto'] = $id_proyecto;
           // Pasar a la vista
            $this->data['id_declaracion'] = $id_declaracion; 
            $this->data['declaraciones'] = $declaraciones;

            $this->template->admin_render('resoluciones/create', array_merge($this->data));
        } else {
            // Si la validación pasa, guarda la resolución
            $data = [
                'id_declaracion' => $this->input->post('id_declaracion'),
                'id_proyecto' => $this->input->post('id_proyecto'),
                'nro_resolucion' => $this->input->post('nro_resolucion'),
                'gestion_resolucion' => $this->input->post('gestion_resolucion'),
                'fecha_resolucion' => $this->input->post('fecha_resolucion'),
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa'),
                'tipo_resoluciones' => $this->input->post('tipo_resoluciones'),
                'estado' => $this->input->post('estado'),
                'observacion' => $this->input->post('observacion'),
            ];
    
            $id_resolucion = $this->Resoluciones_model->create_resolucion($data);
    
            if ($id_resolucion) {
                $folder_path = '/dir_ema/archivos/resoluciones/' . $id_resolucion . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }
    
                if (!empty($_FILES['documento']['name'][0])) {
                    $tipo_documento = '4'; // Tipo de documento para resoluciones
                    $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id_resolucion, $tipo_documento);
    
                    if ($upload_result['status']) {
                        $this->session->set_flashdata('message', 'Resolución y documentos guardados correctamente.');
                    } else {
                        $this->session->set_flashdata('error', 'Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                    }
                } else {
                    $this->session->set_flashdata('message', 'Resolución creada sin documentos.');
                }
    
                redirect('resoluciones/index/' . $id_proyecto);
            } else {
                $this->session->set_flashdata('error', 'No se pudo crear la resolución.');
            }
            // Pasar a la vista
            $this->data['id_declaracion'] = $id_declaracion; 
            $this->data['declaraciones'] = $declaraciones;
            // Insertar datos en la base de datos
            $this->Resoluciones_model->create_resolucion($data);
            redirect('resoluciones/index/'. $id_proyecto);
        }
    }      


    public function edit($id, $id_proyecto = NULL)
    {
        $data['documentos'] = $this->Tumba_model->get_documents_by_project($id, '4');
        if ($this->input->post()) {
            $data = [               
                'id_proyecto'   => $this->input->post('id_proyecto'),    
            ];
            $id_proyecto = $data['id_proyecto'];
        }
        
        // Obtener datos de la resolución por ID
        $data['resolucion'] = $this->Resoluciones_model->get_resolucion_by_id($id);
    
        if (!$data['resolucion']) {
            show_404(); // Si la resolución no existe, muestra un error
        }
    
        // Obtener lista de estados desde el modelo
        $estados = $this->Resoluciones_model->concepto('RESOL_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['nombre']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }
    
        // Obtener lista de tipo_resoluciones desde el modelo
        $tipo_resoluciones = $this->Resoluciones_model->concepto('TIPO_RESOLUCIONES', false, 'CONCEPTO');
        
        // Crear el dropdown de tipo_resoluciones
        $dropdown_tipo_resoluciones = ['' => 'Seleccione un Tipo de Resolución'];  // Opción por defecto
        foreach ($tipo_resoluciones as $tipo_resolucion) {
            // Se asigna el 'concepto' como valor y 'concepto - nombre' como texto visible
            $dropdown_tipo_resoluciones[$tipo_resolucion['concepto']] = $tipo_resolucion['concepto'] . ' - ' . $tipo_resolucion['nombre'];
        }
        
        // Obtener nombre del proyecto
        $nombre_proyecto = $this->Resoluciones_model->get_proyecto_nombre($id_proyecto);
    
        // Reglas de validación del formulario
        $this->form_validation->set_rules('id_declaracion', 'ID Declaración', 'required|numeric');
        $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
        $this->form_validation->set_rules('nro_resolucion', 'Número de Resolución', 'required|numeric|max_length[6]');
        $this->form_validation->set_rules('gestion_resolucion', 'Gestión Resolución', 'required|numeric|max_length[4]');
        $this->form_validation->set_rules('fecha_resolucion', 'Fecha Resolución', 'required');
        $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento AA', 'required');
        $this->form_validation->set_rules('estado', 'Estado', 'required|in_list[A,I]');
        $this->form_validation->set_rules('observacion', 'Observación', 'max_length[10000]');
    
        if ($this->form_validation->run() === FALSE) {
            // Asignar datos necesarios a la vista
            $this->data['id_proyecto']  = $id_proyecto;
            $this->data['lang'] = $this->lang->load('resoluciones/resoluciones', 'spanish');
            
            // Pasar el dropdown de tipo de resoluciones a la vista
            $data['dropdown_tipo_resoluciones'] = $dropdown_tipo_resoluciones;
    
            // Renderizar la vista con los datos
            $this->template->admin_render('resoluciones/edit', array_merge($data, $this->data));
    
        } else {
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'id_declaracion' => $this->input->post('id_declaracion') ?: null,
                'id_proyecto' => $this->input->post('id_proyecto') ?: null,
                'nro_resolucion' => $this->input->post('nro_resolucion') ?: null,
                'gestion_resolucion' => $this->input->post('gestion_resolucion') ?: null,
                'fecha_resolucion' => $this->input->post('fecha_resolucion') ?: null,
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa') ?: null,
                'tipo_resoluciones' => $this->input->post('tipo_resoluciones') ?: null,
                'estado' => $this->input->post('estado') ?: null,
                'observacion' => $this->input->post('observacion') ?: null,
            ];
    
            if (!empty($_FILES['documento']['name'][0])) {
                $folder_path = '/dir_ema/archivos/resoluciones/' . $id . '/';
                if (!is_dir($folder_path)) {
                    mkdir($folder_path, 0777, true);
                }
    
                $tipo_documento = '4';
                $upload_result = $this->Tumba_model->upload_documents('documento', $folder_path, $id, $tipo_documento);
    
                if ($upload_result['status']) {
                    $this->session->set_flashdata('message', 'Resolución actualizada y documentos subidos correctamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al subir documentos: ' . implode(', ', $upload_result['errors']));
                }
            }
            
            // Log para depurar los datos enviados
            log_message('debug', 'Datos actualizados: ' . print_r($datos_actualizados, true));
    
            // Actualizar la resolución en la base de datos
            if ($this->Resoluciones_model->update_resolucion($id, $datos_actualizados)) {
                // Pasar a la vista
                $this->data['id_declaracion'] = $id_declaracion; 
                $this->data['declaraciones'] = $declaraciones;
                $this->session->set_flashdata('message', 'Resolución actualizada correctamente.');
                redirect('resoluciones/edit/' . $id .'/' .$datos_actualizados['id_proyecto']);
            } else {
                log_message('error', 'Error al actualizar la resolución con ID: ' . $id);
                $this->session->set_flashdata('error', 'Error al actualizar la resolución.');
                // Pasar a la vista
                $this->data['id_declaracion'] = $id_declaracion; 
                $this->data['declaraciones'] = $declaraciones;
                redirect('resoluciones/edit/' . $id .'/'.$datos_actualizados['id_proyecto']);
            }
        }
    }
    

    public function delete_document($id_resolucion = null, $id_proyecto = null, $id_documento = null) {
        if (!$id_resolucion || !$id_proyecto || !$id_documento) {
            $this->session->set_flashdata('error', 'Error: Faltan datos para eliminar el documento.');
            redirect('resoluciones/edit/' . $id_resolucion . '/' . $id_proyecto);
            return;
        }
    
        // Verificar si el documento existe
        $documento = $this->Tumba_model->get_project_by_document($id_documento,'4');
        if (!$documento) {
            $this->session->set_flashdata('error', 'El documento no existe o ya fue eliminado.');
            redirect('resoluciones/edit/' . $id_resolucion . '/' . $id_proyecto);
            return;
        }
    
        // Intentar eliminar
        if ($this->Tumba_model->delete_document($id_documento, '4')) {
            $this->session->set_flashdata('message', 'Documento eliminado correctamente.');
        } else {
            $this->session->set_flashdata('error', 'No se pudo eliminar el documento.');
        }
    
        redirect('resoluciones/edit/' . $id_resolucion . '/' . $id_proyecto);
    }

    public function views($id, $id_proyecto = NULL)
    {
        // Obtener datos de la resolución por ID
        $data['resolucion'] = $this->Resoluciones_model->get_resolucion_by_id($id);
         // Obtener el nombre del proyecto por el ID
         $nombre_proyecto = $this->Resoluciones_model->get_proyecto_nombre($id_proyecto);

         // Pasar el nombre del proyecto a la vista
         $data['nombre_proyecto'] = $nombre_proyecto;

        if (!$data['resolucion']) {
            show_404(); // Si la resolución no existe, muestra un error
        }

        if ($this->form_validation->run() === FALSE) {
            $this->data['lang'] = $this->lang->load('resoluciones/resoluciones', 'spanish');
            $this->template->admin_render('resoluciones/views', array_merge($data, $this->data));
        } else {
            // Preparar los datos para actualizar
            $datos_actualizados = [
                'id_declaracion' => $this->input->post('id_declaracion') ?: null,
                'id_proyecto' => $this->input->post('id_proyecto') ?: null,
                'nro_resolucion' => $this->input->post('nro_resolucion') ?: null,
                'gestion_resolucion' => $this->input->post('gestion_resolucion') ?: null,
                'fecha_resolucion' => $this->input->post('fecha_resolucion') ?: null,
                'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa') ?: null,
                'tipo_resoluciones' => $this->input->post('tipo_resoluciones') ?: null,
                'estado' => $this->input->post('estado') ?: null,
                'observacion' => $this->input->post('observacion') ?: null,
            ];

            // Log para depurar los datos enviados
            log_message('debug', 'Datos actualizados: ' . print_r($datos_actualizados, true));

            // Actualizar la resolución en la base de datos
            if ($this->Resoluciones_model->update_resolucion($id, $datos_actualizados)) {
                $this->session->set_flashdata('message', 'Resolución actualizada correctamente.');
                redirect('resoluciones/index/'.$datos_actualizados['id_proyecto']);
            } else {
                log_message('error', 'Error al actualizar la resolución con ID: ' . $id);
                $this->session->set_flashdata('error', 'Error al actualizar la resolución.');
                redirect('resoluciones/views/' . $id .'/'.$datos_actualizados['id_proyecto']);
            }
        }
    }


    public function delete($id,$id_proyecto=NULL) {
        $this->Resoluciones_model->delete_resolucion($id);
        redirect('resoluciones/index/'.$id_proyecto);
    }
}
